// UndoRedo.cpp: implementation of the CUndoRedo class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "boulder.h"
#include "UndoRedo.h"

#include "MapBlock.h"
#include "BlockMonster.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CUndoRedo::CUndoRedo()
{
}

CUndoRedo::~CUndoRedo()
{
	Reset ();	
}

//////////////////////////////////////////////////////////////////////
void CUndoRedo::Undo (CBoulderMap* pMap)
{
	BYTE* pBuff = new BYTE[MAP_WIDTH * MAP_HEIGHT];
	ConvertMapToIndexes (pMap, pBuff);
	m_redoList.AddTail (pBuff);

	pBuff= m_undoList.RemoveTail ();
	ConvertIndexesToMap (pMap, pBuff);
	delete pBuff;
}

//////////////////////////////////////////////////////////////////////
void CUndoRedo::Redo (CBoulderMap* pMap)
{
	BYTE* pBuff = new BYTE[MAP_WIDTH * MAP_HEIGHT];
	ConvertMapToIndexes (pMap, pBuff);
	m_undoList.AddTail (pBuff);

	pBuff= m_redoList.RemoveTail ();
	ConvertIndexesToMap (pMap, pBuff);
	delete pBuff;
}

//////////////////////////////////////////////////////////////////////
void CUndoRedo::Update (CBoulderMap* pMap)
{
	if (m_undoList.GetCount () > 1000)
		return;

	int n = m_redoList.GetCount ();
	for (int i = 0; i < n; i++)
		delete m_redoList.RemoveTail ();
	
	BYTE* pBuff = new BYTE[MAP_WIDTH * MAP_HEIGHT];
	ConvertMapToIndexes (pMap, pBuff);
	m_undoList.AddTail (pBuff);
}

//////////////////////////////////////////////////////////////////////
void CUndoRedo::ConvertMapToIndexes (CBoulderMap* pMap, BYTE* pBuff)
{
	int pos = 0;
	for (int y = 0; y < MAP_HEIGHT; y++)
		for (int x = 0; x < MAP_WIDTH; x++)
		{
			CBlockMonster* pBlock = (CBlockMonster*)pMap->GetMapItemIndirect (CPoint (x, y));
			int type = pBlock->GetBlockType ();

			if (type == BLOCK_MONSTER)
				type = pBlock->GetMonsterType ();

			pBuff[pos++] = pMap->ConvertMapIndex (type);
		}
}

//////////////////////////////////////////////////////////////////////
void CUndoRedo::ConvertIndexesToMap (CBoulderMap* pMap, BYTE* pBuff)
{
	for (int y = 0; y < MAP_HEIGHT; y++)
		for (int x = 0; x < MAP_WIDTH; x++)
			pMap->ChangeMapItem (CPoint (x, y), pMap->CreateNewBlock (pMap->ConvertFileIndex (pBuff[x + y * MAP_WIDTH])));
}

//////////////////////////////////////////////////////////////////////
BOOL CUndoRedo::CanUndo ()
{
	if (!m_undoList.GetCount ())
		return FALSE;

	return TRUE;
}

//////////////////////////////////////////////////////////////////////
BOOL CUndoRedo::CanRedo ()
{
	if (!m_redoList.GetCount ())
		return FALSE;

	return TRUE;
}

//////////////////////////////////////////////////////////////////////
void CUndoRedo::Reset ()
{
	int n = m_undoList.GetCount ();
	for (int i = 0; i < n; i++)
		delete m_undoList.RemoveTail ();
	
	n = m_redoList.GetCount ();
	for (i = 0; i < n; i++)
		delete m_redoList.RemoveTail ();
}