// Sound.h: interface for the CSound class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SOUND_H__320A00DA_4B3E_4ED2_A5ED_F18501BE471B__INCLUDED_)
#define AFX_SOUND_H__320A00DA_4B3E_4ED2_A5ED_F18501BE471B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <mmsystem.h>
#include <DSound.h>
#include <atlbase.h>
#include <afxtempl.h>

class CSound
{
	struct SoundBuffer
	{
		CComQIPtr<IDirectSoundBuffer, &IID_IDirectSoundBuffer> IBuffer;
		CComQIPtr<IDirectSoundNotify, &IID_IDirectSoundNotify> INotify;
		DSBUFFERDESC		bd;
		WAVEFORMATEX		wfx;
		CString				strFileName;
		int					index;
	};

	CComPtr<IDirectSound>	m_IDSound;
	CTypedPtrList<CPtrList, SoundBuffer*> m_listBuffers;

	SoundBuffer*		FindBuffer (int index);

public:
	CSound();
	virtual ~CSound();

	enum				{ONCE = 0, LOOPING};

	BOOL				LoadWaveFromFile (LPCSTR pFileName, int index);
	BOOL				Play (int index, int mode = ONCE);
};

#endif // !defined(AFX_SOUND_H__320A00DA_4B3E_4ED2_A5ED_F18501BE471B__INCLUDED_)
