// Player.h: interface for the CPlayer class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PLAYER_H__15B0E142_C47C_11D5_874B_00A0C9697DFA__INCLUDED_)
#define AFX_PLAYER_H__15B0E142_C47C_11D5_874B_00A0C9697DFA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CPlayer : public CObject  
{
public:
	CString				m_strPlayerName;
	CString				m_strMapName;
	int					m_nLives;
	int					m_nTotalScore;
	int					m_nCurLevelNum;
	int					m_nLevelsComplete;
	int					m_playerStatus;

public:
	CPlayer();
	CPlayer (CString &str);
	CPlayer (CString &str, CString &strMapName);
	CPlayer (CString &str, int nCurLevelNum);
	CPlayer (CString &str, CString &strMapName, int nLives, int nTotalScore, int nCurLevelNum, int nLevelsCompite);
	virtual ~CPlayer();

	virtual void		Serialize(CArchive& ar);

	void				operator= (const CPlayer &player);
	BOOL				LoadPlayer (CString &fileName);
	BOOL				SavePlayer (CString &fileName);
	void				ResetPlayer (CString &strName);

	DECLARE_SERIAL (CPlayer)
};

#endif // !defined(AFX_PLAYER_H__15B0E142_C47C_11D5_874B_00A0C9697DFA__INCLUDED_)
