// Player.cpp: implementation of the CPlayer class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "boulder.h"
#include "Player.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

IMPLEMENT_SERIAL (CPlayer, CObject, 0);

CPlayer::CPlayer()
{
	CString str;
	str.LoadString (IDS_EMPTY_PLAYER_NAME);
	ResetPlayer (str);
}

CPlayer::CPlayer (CString &str)
{
	ResetPlayer (str);
}

CPlayer::CPlayer (CString &str, CString &strMapName)
{
	ResetPlayer (str);
	m_strMapName = strMapName;
}

CPlayer::CPlayer (CString &str, int nCurLevelNum)
{
	ResetPlayer (str);
	m_nCurLevelNum = nCurLevelNum;
}

CPlayer::CPlayer (CString &str, CString &strMapName,  int nLives, int nTotalScore, int nCurLevelNum, int nLevelsComplete)
{
	m_strPlayerName = str;
	m_strMapName = strMapName;
	m_nLives = nLives;
	m_nTotalScore = nTotalScore;
	m_nCurLevelNum = nCurLevelNum;
	m_nLevelsComplete = nLevelsComplete;
	m_playerStatus = 0;
}

CPlayer::~CPlayer()
{
}

//////////////////////////////////////////////////////////////////////
void CPlayer::Serialize(CArchive& ar)
{
	if (ar.IsLoading ())
	{
		ar>>m_strPlayerName;
		ar>>m_strMapName;
		ar>>m_nLives;
		ar>>m_nTotalScore;
		ar>>m_nCurLevelNum;
		ar>>m_nLevelsComplete;
		ar>>m_playerStatus;
	}
	else
	{
		ar<<m_strPlayerName;
		ar<<m_strMapName;
		ar<<m_nLives;
		ar<<m_nTotalScore;
		ar<<m_nCurLevelNum;
		ar<<m_nLevelsComplete;
		ar<<m_playerStatus;
	}
}

//////////////////////////////////////////////////////////////////////
void CPlayer::operator= (const CPlayer &player)
{
	m_strPlayerName		= player.m_strPlayerName;
	m_strMapName		= player.m_strMapName;
	m_nLives			= player.m_nLives;
	m_nTotalScore		= player.m_nTotalScore;
	m_nCurLevelNum		= player.m_nCurLevelNum;
	m_nLevelsComplete	= player.m_nLevelsComplete;
	m_playerStatus		= player.m_playerStatus;
}

//////////////////////////////////////////////////////////////////////
BOOL CPlayer::LoadPlayer (CString &fileName)
{
	CFile file;
	CFileStatus status;
	if (file.GetStatus (fileName, status))
	{
		file.Open (fileName, CFile::modeRead);
		CArchive ar(&file, CArchive::load);
		Serialize (ar);
	}
	else
	{
		CString str;
		str.LoadString (IDS_NO_PLAYER_FOUND);
		AfxMessageBox (str, MB_OK|MB_ICONSTOP);
		return TRUE;
	}

	return FALSE;
}

//////////////////////////////////////////////////////////////////////
BOOL CPlayer::SavePlayer (CString &fileName)
{
	CFile file;
	/*
	CFileStatus status;
	if (file.GetStatus (fileName, status))
	{
		CString str, str1;
		str1.LoadString (IDS_REPLACE_PLAYER);
		str.Format (str1, fileName);
		if (AfxMessageBox (str, MB_YESNO|MB_ICONSTOP) == IDNO)
			return TRUE;
	}
	*/
	file.Open (fileName, CFile::modeCreate|CFile::modeWrite);
	CArchive ar(&file, CArchive::store);
	Serialize (ar);

	return FALSE;
}

//////////////////////////////////////////////////////////////////////
void CPlayer::ResetPlayer (CString &strName)
{
	CString str;
	str.LoadString (IDS_DEFUALT_MAP_NAME);
	m_strPlayerName = strName;
	m_strMapName = str;
	m_nLives = NUMBER_OF_LIVES_ON_START;
	m_nTotalScore = 0;
	m_nCurLevelNum = START_LEVEL;
	m_nLevelsComplete = 0;
	m_playerStatus = 0;
}
