// MapEngine.h: interface for the CMapEngine class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAPENGINE_H__5D2F0D42_6710_11D5_874B_00A0C9697DFA__INCLUDED_)
#define AFX_MAPENGINE_H__5D2F0D42_6710_11D5_874B_00A0C9697DFA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "BoulderMap.h"
#include "BlockBoulder.h"

class CMapEngine  
{
	CBoulderMap*			m_pMap;
	
	CBlockBoulder*		m_pBoulder;
	CPoint				m_ptBoulderPos;
	
	int					m_curKeyPressed;
	BOOL				m_bAllUnpressed;

	int					m_nGold;
	
	void				InitBoulder ();
	void				ShiftDinamicBlocks ();
	void				ShiftBoulder ();
	void				ShiftMonsters ();
	int					FindMonsterMovement (int axis, CPoint ptPos);
	BOOL				CanMonsterMove (int movement, CPoint ptPos);
	BOOL				IsBlockHasZerroOffset (CPoint ptPos, int type);
	int					TranslateMovementToAxis (int movement);

public:
	CMapEngine ();
	CMapEngine(CBoulderMap* pMap);
	virtual ~CMapEngine();

	void				Create (CBoulderMap* pMap);

	void				KillBoulder ();
	BOOL				IsBoulderDied ();
	CPoint				GetBoulderPos ();
	void				MoveDinamicBlocks ();
	void				MoveBoulder (int key, BOOL allUnpressed);
	void				MoveMonsters ();
	void				IncreaseState ();
	int					DoExplosion (CPoint ptPos);
	void				ClearOldExplosion (int type);
	BOOL				CheckForBoulderExplosion ();
	BOOL				CheckForMonstersExplosion ();
	BOOL				CheckForLevelComplete ();
	int 				CheckForEat (CPoint ptPos);
	void				SetKey (int key){m_curKeyPressed = key;}
	int					GetKey () {return m_curKeyPressed;}
	void				SetAllUnpressedFlag (int flag){m_bAllUnpressed = flag;}
	void				SetBoulderPos (CPoint ptPos){m_ptBoulderPos = ptPos;}
	BOOL				ShiftStonesRight (CPoint ptPos);
	BOOL				ShiftStonesLeft (CPoint ptPos);
	BOOL				ShiftStonesUp (CPoint ptPos);
};

#endif // !defined(AFX_MAPENGINE_H__5D2F0D42_6710_11D5_874B_00A0C9697DFA__INCLUDED_)
