#if !defined(AFX_MAPEDITOR_H__58C9BCC1_813A_11D5_ADEB_00E098920EFC__INCLUDED_)
#define AFX_MAPEDITOR_H__58C9BCC1_813A_11D5_ADEB_00E098920EFC__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// MapEditor.h : header file
//

#include "BoulderMap.h"
#include "BoulderEditBar.h"

#include "UndoRedo.h"

/////////////////////////////////////////////////////////////////////////////
// CMapEditor view

class CMapEditor : public CView
{
protected:
	//CMapEditor();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CMapEditor)

// Attributes
protected:
	CBitmap				m_bmBackBuff;
	CString				m_strFileName;

	BOOL				m_bModifed;
	BOOL				m_bEnableAnimation;

	CPoint				m_ptCursorPos;
	BOOL				m_bKeyPressed;
	int					m_editKeyPressed;
	
	BOOL				m_bLButtonPressed;
	CPoint				m_ptClickPos;
	CPoint				m_ptMovePos;

// Operations
public:
	CMapEditor();

virtual ~CMapEditor();	

	CUndoRedo			m_oUndoRedo;

	void				SetFileName (CString strFileName);
	void				InitLevelList (CComboBox* pCombo);
	CBoulderMap*			GetMap (){return m_pMap;}
	BOOL				SaveModifedLevel ();
	BOOL				AddNewLevel (int iLevel, int fill);
	BOOL				DeleteLevel (int iLevel);
		
	void				StartTimer ();
	void				StopTimer ();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMapEditor)
	public:
	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	//}}AFX_VIRTUAL

// Implementation
protected:
	CBoulderMap*					m_pMap;
	CBoulderEditBar				m_editBar;

	void				DrawCursor (CDC* pDC, CPoint ptPos);
	void				SelectLevel (int nLevel, CString strLevelName);
	void				IncreaseState ();
	void				SetMapBlockInView (CPoint ptView, int block);
	void				SetMapBlockInMap (CPoint ptMap, int block);
	int 				GetMapBlock (CPoint ptMap);
	void				DrawLineInMap (CPoint beg, CPoint end);
	void				PaintMapInView (CPoint ptView, int block, int wayBlock);
	void				PaintMapInMap (CPoint ptView, int block, int wayBlock);
	void				FillMap (int block);
	void				DrawLineCursor (CDC* pMemDC, CPoint beg, CPoint end);
	CPoint				ViewToMap (CPoint ptView);
	
	BOOL				TestExistanceOfMapFile ();
	
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(CMapEditor)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnEditAddnewlevel();
	afx_msg void OnEditDeletelevel();
	afx_msg void OnEditShowtoolwindow();
	afx_msg void OnUpdateEditShowtoolwindow(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnCaptureChanged(CWnd *pWnd);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnEditUndo();
	afx_msg void OnUpdateEditUndo(CCmdUI* pCmdUI);
	afx_msg void OnEditRedo();
	afx_msg void OnUpdateEditRedo(CCmdUI* pCmdUI);
	afx_msg void OnEditSwitchtoeditwindow();
	afx_msg void OnEditSavelevel();
	//}}AFX_MSG
	afx_msg void OnEbCombo ();
	DECLARE_MESSAGE_MAP()
};

struct CURSOR_PARAM
{
	CBoulderMap*			pMap;
	CBoulderEditBar*		pBar;
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAPEDITOR_H__58C9BCC1_813A_11D5_ADEB_00E098920EFC__INCLUDED_)
