// MainFrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAINFRM_H__5E12EF29_B755_11D5_ADEB_00E098920EFC__INCLUDED_)
#define AFX_MAINFRM_H__5E12EF29_B755_11D5_ADEB_00E098920EFC__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "GameField.h"
#include "MapEditor.h"
#include "ScoreTable.h"

class CMainFrame : public CFrameWnd
{
	
public:
	CMainFrame();
protected: 
	DECLARE_DYNAMIC(CMainFrame)

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainFrame)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMainFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

// Generated message map functions
protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg void OnFileNewgame();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnEditStartmapeditor();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnClose();
	afx_msg void OnEditTestcurrentlevel();
	afx_msg void OnUpdateEditTestcurrentlevel(CCmdUI* pCmdUI);
	afx_msg void OnVisitstoiksoftwarehomepage();
	afx_msg void OnUpdateEditStarteditor(CCmdUI* pCmdUI);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnScore();
	afx_msg void OnFileRestartlevel();
	afx_msg void OnUpdateFileRestartlevel(CCmdUI* pCmdUI);
	afx_msg void OnFileReturntogame();
	afx_msg void OnUpdateFileReturntogame(CCmdUI* pCmdUI);
	afx_msg void OnFileLoadgame();
	afx_msg void OnUpdateFileLoadgame(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:
	void					SetCurLevel (int nLevel){m_curLevelNum = nLevel;}

protected:
	CMenu					m_menu;

	CGameField*				m_pField;
	CMapEditor*				m_pEditor;
	CScoreTable*			m_pScore;
	int						m_curLevelNum;
	int						m_idTimer;
	int						m_curKey;
	int						m_nKeysPressed;

	void					NewGame (BOOL bLoad, CString &strName);
	void					CreateScoreTable ();
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAINFRM_H__5E12EF29_B755_11D5_ADEB_00E098920EFC__INCLUDED_)
