// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "Boulder.h"

#include "MainFrm.h"
#include "NewGameDlg.h"
#include "LoadPlayerDlg.h"
#include "StoikDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_COMMAND(ID_FILE_NEWGAME, OnFileNewgame)
	ON_WM_ERASEBKGND()
	ON_COMMAND(ID_EDIT_STARTEDITOR, OnEditStartmapeditor)
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_COMMAND(ID_EDIT_TESTCURRENTLEVEL, OnEditTestcurrentlevel)
	ON_UPDATE_COMMAND_UI(ID_EDIT_TESTCURRENTLEVEL, OnUpdateEditTestcurrentlevel)
	ON_COMMAND(ID__VISITSTOIKSOFTWAREHOMEPAGE, OnVisitstoiksoftwarehomepage)
	ON_UPDATE_COMMAND_UI(ID_EDIT_STARTEDITOR, OnUpdateEditStarteditor)
	ON_WM_SETFOCUS()
	ON_COMMAND(ID_SCORE, OnScore)
	ON_COMMAND(ID_FILE_RESTARTLEVEL, OnFileRestartlevel)
	ON_UPDATE_COMMAND_UI(ID_FILE_RESTARTLEVEL, OnUpdateFileRestartlevel)
	ON_COMMAND(ID_FILE_RETURNTOGAME, OnFileReturntogame)
	ON_UPDATE_COMMAND_UI(ID_FILE_RETURNTOGAME, OnUpdateFileReturntogame)
	ON_COMMAND(ID_FILE_LOADGAME, OnFileLoadgame)
	ON_UPDATE_COMMAND_UI(ID_FILE_LOADGAME, OnUpdateFileLoadgame)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

/////////////////////////////////////////////////////////////////////////////
CMainFrame::CMainFrame()
{
	m_pField = NULL;
	m_pEditor = NULL;
	m_pScore = NULL;
}

/////////////////////////////////////////////////////////////////////////////
CMainFrame::~CMainFrame()
{
	delete m_pScore;
}

/////////////////////////////////////////////////////////////////////////////
BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	cs.style = NULL;
	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	cs.lpszClass = AfxRegisterWndClass (0, 0, 0, ::LoadIcon (AfxGetResourceHandle (), MAKEINTRESOURCE (IDR_MAINFRAME)));
	
	m_menu.LoadMenu (IDR_BOULDERMENU);
//#ifndef _DEBUG
//	m_menu.RemoveMenu (3, MF_BYPOSITION);
//	m_menu.RemoveMenu (3, MF_BYPOSITION);
//#endif
	cs.hMenu = m_menu.GetSafeHmenu ();

	return TRUE;
}

#ifdef _DEBUG
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

/////////////////////////////////////////////////////////////////////////////
int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	CRect rcWindow, rcClient;
	GetWindowRect (&rcWindow);
	GetClientRect (&rcClient);

	rcWindow.right -= rcClient.right;
	rcWindow.bottom -= rcClient.bottom;

	SetWindowPos (NULL, 100, 100, 
		rcWindow.right + BLOCK_WIDTH * MAP_WIDTH,
		rcWindow.bottom + BLOCK_HEIGHT * MAP_HEIGHT, SWP_NOZORDER);

	GetClientRect (&rcClient);

	ModifyStyle (0, WS_SYSMENU|WS_MINIMIZEBOX);

	CreateScoreTable ();

	m_hAccelTable = LoadAccelerators (AfxGetResourceHandle (), MAKEINTRESOURCE(IDR_MAINFRAME));
	ASSERT(m_hAccelTable);
	
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnClose() 
{
	if (m_pEditor && !m_pEditor->SaveModifedLevel ())
		return;

	CFrameWnd::OnClose();
}

/////////////////////////////////////////////////////////////////////////////
BOOL CMainFrame::OnEraseBkgnd(CDC* pDC) 
{
	if (!m_pField && !m_pEditor && !m_pScore->IsWindowVisible ())
	{
		CRect rc;
		GetClientRect (&rc);

		CBrush br, *oldBr;
		br.CreateSolidBrush (::GetSysColor (COLOR_3DFACE));
		oldBr = pDC->SelectObject (&br);
		pDC->PatBlt (0, 0, rc.Width (), rc.Height (), PATCOPY);
		pDC->SelectObject (oldBr);
	}
	
	return TRUE;
	//return CFrameWnd::OnEraseBkgnd(pDC);
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnFileNewgame()
{
	CNewGameDlg dlg;
	if (dlg.DoModal () == IDCANCEL)
		return;

	NewGame (FALSE, dlg.m_strPlayerName);
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnFileLoadgame() 
{
	CFileDialog dlg (TRUE, NULL, NULL, 
		OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT|OFN_NOCHANGEDIR,
		"*.sav|*.sav|", this);
	if (dlg.DoModal () == IDCANCEL)
		return;

	NewGame (TRUE, dlg.GetPathName ());
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateFileLoadgame(CCmdUI* pCmdUI) 
{
	if (!m_pField)
		pCmdUI->Enable (TRUE);
	//else
		//pCmdUI->Enable (m_pField->IsGameEngineStarted ());
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::NewGame (BOOL bLoad, CString &strName)
{
	if (m_pScore)
		m_pScore->ShowWindow (SW_HIDE);

	
	if (m_pEditor)
		m_pEditor->ShowWindow (SW_HIDE);
	
	if (m_pField)
	{
		m_pField->ShowWindow (SW_SHOW);
	}
	else
	{
		CRect rc;
		GetClientRect (&rc);
	
		m_pField = new CGameField;
		m_pField->Create (NULL, NULL, WS_VISIBLE|WS_CHILD, rc, this, 0);
		m_pField->AttachScoreTable (m_pScore);
	}

	if (bLoad)
		m_pField->m_player.LoadPlayer (strName);
	else
		m_pField->m_player.ResetPlayer (strName);

	m_pField->SetFocus ();
	m_pField->StartNewGame ();
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnEditStartmapeditor() 
{
	if (m_pScore)
		m_pScore->ShowWindow (SW_HIDE);

	if (m_pField)
		m_pField->ShowWindow (SW_HIDE);
	
	if (m_pEditor)
		m_pEditor->ShowWindow (SW_SHOW);
	else
	{
		CRect rc;
		GetClientRect (&rc);
		
		m_pEditor = new CMapEditor;
		m_pEditor->Create (NULL, NULL, WS_VISIBLE|WS_CHILD, rc, this, 0);
	}

	m_pEditor->SetFocus ();
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateEditStarteditor(CCmdUI* pCmdUI) 
{
	CString str;

	if (m_pEditor)
	{
		if (m_pEditor->IsWindowVisible ())
			pCmdUI->Enable (FALSE);
		else
		{
			str.LoadString (IDS_MENU_BACK_TO_EDITOR);
			pCmdUI->SetText (str);
			pCmdUI->Enable (TRUE);
		}
	}
	else 
	{
		str.LoadString (IDS_MENU_START_EDITOR);
		pCmdUI->SetText (str);
		pCmdUI->Enable (TRUE);
	}
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnEditTestcurrentlevel() 
{
	if (m_pEditor)
		m_pEditor->ShowWindow (SW_HIDE);
	
	if (m_pField)
		m_pField->ShowWindow (SW_SHOW);
	else
	{
		CRect rc;
		GetClientRect (&rc);
	
		m_pField = new CGameField;
		m_pField->Create (NULL, NULL, WS_VISIBLE|WS_CHILD, rc, this, 0);
	}

	m_pField->StartNewGame (m_pEditor->GetMap ());
	m_pField->SetFocus ();	
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateEditTestcurrentlevel(CCmdUI* pCmdUI) 
{
	if (m_pEditor && m_pEditor->IsWindowVisible ())
		pCmdUI->Enable (TRUE);
	else
		pCmdUI->Enable (FALSE);
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnVisitstoiksoftwarehomepage() 
{
	CStoikDlg dlg (this);
	dlg.DoModal ();
}

/////////////////////////////////////////////////////////////////////////////
BOOL CMainFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo) 
{
	if (m_pEditor && 
		IsWindow (m_pEditor->m_hWnd) &&
		m_pEditor->IsWindowVisible () &&
		m_pEditor->OnCmdMsg (nID, nCode, pExtra, pHandlerInfo))
		return TRUE;
	else
		return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnSetFocus(CWnd* pOldWnd) 
{	
	if (m_pField && m_pField->IsWindowVisible ())
		m_pField->SetFocus ();
	else if (m_pEditor && m_pEditor->IsWindowVisible ())
		m_pEditor->SetFocus ();
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::CreateScoreTable ()
{
	CRect rc;
	GetClientRect (&rc);

	m_pScore = new CScoreTable ();
	m_pScore->Create (WS_CHILD|WS_BORDER|LVS_REPORT|LVS_OWNERDRAWFIXED, rc, this, 0);
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnScore() 
{	
	static CWnd* pFocus; 
	static BOOL bIsGame = TRUE;

	if (!m_pScore->IsWindowVisible ())
	{
		pFocus = GetFocus ();

		if (m_pField)
		{
			if (m_pField->IsWindowVisible ())
				bIsGame = TRUE;

			m_pField->ShowWindow (SW_HIDE);
		}
		
		if (m_pEditor)
		{
			if (m_pEditor->IsWindowVisible ())
				bIsGame = FALSE;

			m_pEditor->ShowWindow (SW_HIDE);
		}

		m_pScore->ShowWindow (SW_SHOW);
	}
	else
	{
		m_pScore->ShowWindow (SW_HIDE);

		if (bIsGame)
		{
			if (m_pField)
				m_pField->ShowWindow (SW_SHOW);
		}
		else
		{
			if (m_pEditor)
				m_pEditor->ShowWindow (SW_SHOW);
		}
	
		if (pFocus)
			pFocus->SetFocus ();
	}
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnFileRestartlevel() 
{
	m_pField->RestartLevel ();	
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateFileRestartlevel(CCmdUI* pCmdUI) 
{
	if (!m_pField || !m_pField->IsWindowVisible ())
		pCmdUI->Enable (FALSE);
	else
		pCmdUI->Enable (m_pField->IsGameEngineStarted ());
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnFileReturntogame() 
{
	m_pScore->ShowWindow (SW_HIDE);

	if (m_pEditor)
		m_pEditor->ShowWindow (SW_HIDE);
	
	if (m_pField)
	{
		m_pField->ShowWindow (SW_SHOW);
		m_pField->SetFocus ();
	}		
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateFileReturntogame(CCmdUI* pCmdUI) 
{
	if (m_pField && !m_pField->IsWindowVisible ())
		pCmdUI->Enable (TRUE);
	else
		pCmdUI->Enable (FALSE);
}