// BoulderText.cpp: implementation of the CBoulderText class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "boulder.h"
#include "BoulderText.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CBoulderText::CBoulderText()
{
	m_pFnt = NULL;
	m_textColor = RGB (255, 255, 255);
	m_textSize = 130;
	m_bBorder = FALSE;

	SetTextSize (m_textSize);
}

CBoulderText::~CBoulderText()
{
	delete m_pFnt;
}

//////////////////////////////////////////////////////////////////////
void CBoulderText::DrawText (CDC* pDC, CString &str, CRect rect, int uFormat)
{
	CRect rcShadow;
	rcShadow = rect;
	rcShadow.OffsetRect (2, 2);
	
	CFont* fntOld = pDC->SelectObject (m_pFnt);
	pDC->SetBkMode (TRANSPARENT);
	pDC->SetTextColor (RGB (0, 0, 0));
	pDC->DrawText (str, &rcShadow, uFormat);
	if (m_bBorder)
	{
		rect.OffsetRect (1, 0);
		pDC->DrawText (str, &rect, uFormat);
		rect.OffsetRect (-2, 0);
		pDC->DrawText (str, &rect, uFormat);
		rect.OffsetRect (1, 1);
		pDC->DrawText (str, &rect, uFormat);
		rect.OffsetRect (0, -2);
		pDC->DrawText (str, &rect, uFormat);
		rect.OffsetRect (0, 1);
	}
	pDC->SetTextColor (m_textColor);
	pDC->DrawText (str, &rect, uFormat);
	pDC->SelectObject (fntOld);
}

//////////////////////////////////////////////////////////////////////
void CBoulderText::SetTextSize (int size)
{
	if (!m_pFnt || size != m_textSize)
	{
		delete m_pFnt;

		CString strFnt;
		strFnt.LoadString (IDS_DEFAULT_FONT_NAME);
		
		m_pFnt = new CFont;
		m_pFnt->CreatePointFont (size, strFnt);
		m_textSize = size;
	}
}