// BoulderEditBar.cpp : implementation file
//

#include "stdafx.h"
#include "boulder.h"
#include "BoulderEditBar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBoulderEditBar

CBoulderEditBar::CBoulderEditBar()
{
	m_pImgList = NULL;
	m_pMessageSink = NULL;

	m_nTool = EDIT_TOOL_NORMAL;
}

CBoulderEditBar::~CBoulderEditBar()
{
	delete m_pImgList;	
}


BEGIN_MESSAGE_MAP(CBoulderEditBar, CDialogBar)
	//{{AFX_MSG_MAP(CBoulderEditBar)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
	ON_COMMAND (IDC_EB_NORMAL, OnEbNormal)
	ON_COMMAND (IDC_EB_LINE, OnEbLine)
	ON_COMMAND (IDC_EB_PAINT, OnEbPaint)
	ON_COMMAND (IDC_EB_FILL, OnEbFill)
	ON_CBN_CLOSEUP (IDC_EB_COMBO, OnEbComboClose)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBoulderEditBar message handlers

/////////////////////////////////////////////////////////////////////////////
int CBoulderEditBar::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialogBar::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	//int wndWidth = 150;
	//int wndHeight = 350;
	
	// Set Editbar position
	//CRect rc;
	//GetParent ()->GetWindowRect (&rc);
	//SetWindowPos (NULL, rc.right - wndWidth, rc.bottom - wndHeight, wndWidth, wndHeight, SWP_NOZORDER);
	
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
void CBoulderEditBar::InitEditBar (CWnd* pMessageSink)
{
	m_pMessageSink = pMessageSink;

	// Load tools bitmaps
	m_bmNormal.LoadBitmap (IDB_TB_NORMAL);
	m_bmLine.LoadBitmap (IDB_TB_LINE);
	m_bmPaint.LoadBitmap (IDB_TB_PAINT);
	m_bmFill.LoadBitmap (IDB_TB_FILL);

	CButton* pBtn; 
	pBtn = ((CButton*)GetDlgItem (IDC_EB_NORMAL));
	pBtn->SetBitmap ((HBITMAP)m_bmNormal.m_hObject);
	pBtn = ((CButton*)GetDlgItem (IDC_EB_LINE));
	pBtn->SetBitmap ((HBITMAP)m_bmLine.m_hObject);
	pBtn = ((CButton*)GetDlgItem (IDC_EB_PAINT));
	pBtn->SetBitmap ((HBITMAP)m_bmPaint.m_hObject);
	pBtn = ((CButton*)GetDlgItem (IDC_EB_FILL));
	pBtn->SetBitmap ((HBITMAP)m_bmFill.m_hObject);
	
	// Prepere listctrl
	m_pImgList = new CImageList ();
	m_pImgList->Create (BLOCK_WIDTH, BLOCK_HEIGHT, ILC_COLORDDB, MAP_SPRITES_NUM, MAP_SPRITES_NUM);

	CBitmap bm;
	bm.LoadBitmap (IDB_MAPSPRITES);

	m_pImgList->Add (&bm, RGB (0, 0, 0));	
		
	CListCtrl* pList = ((CListCtrl*)GetDlgItem (IDC_EB_LIST));
	pList->SetImageList (m_pImgList, LVSIL_NORMAL);
	pList->SetTextColor (RGB (255, 255, 255));
	pList->SetBkColor (RGB (0, 0, 0));
	pList->SetTextBkColor (RGB (0, 0, 0));
	
	// Add all blocks to editor listctrl
	CString str;
	LVITEM	lvi;
	lvi.mask = LVIF_IMAGE|LVIF_TEXT|LVIF_PARAM;
	lvi.iSubItem = 0;

	str.LoadString (IDS_BLOCK_SPACE);
	lvi.iItem = 0;
	lvi.pszText = (LPSTR)(LPCTSTR)str;
	lvi.lParam = BLOCK_SPACE;
	lvi.iImage = 0;
	pList->InsertItem (&lvi);

	str.LoadString (IDS_BLOCK_GROUND);
	lvi.iItem = 1;
	lvi.pszText = (LPSTR)(LPCTSTR)str;
	lvi.lParam = BLOCK_GROUND;
	lvi.iImage = 1;
	pList->InsertItem (&lvi);

	str.LoadString (IDS_BLOCK_ARMOR);
	lvi.iItem = 2;
	lvi.pszText = (LPSTR)(LPCTSTR)str;
	lvi.lParam = BLOCK_ARMOR;
	lvi.iImage = 2;
	pList->InsertItem (&lvi);

	str.LoadString (IDS_BLOCK_GOLD);
	lvi.iItem = 3;
	lvi.pszText = (LPSTR)(LPCTSTR)str;
	lvi.lParam = BLOCK_GOLD;
	lvi.iImage = 3;
	pList->InsertItem (&lvi);
	
	str.LoadString (IDS_BLOCK_STONE);
	lvi.iItem = 4;
	lvi.pszText = (LPSTR)(LPCTSTR)str;
	lvi.lParam = BLOCK_STONE;
	lvi.iImage = 7;
	pList->InsertItem (&lvi);
	
	str.LoadString (IDS_BLOCK_PLAYER);
	lvi.iItem = 5;
	lvi.pszText = (LPSTR)(LPCTSTR)str;
	lvi.lParam = BLOCK_BOULDER;
	lvi.iImage = 11;
	pList->InsertItem (&lvi);

	str.LoadString (IDS_BLOCK_BUTTERFLY);
	lvi.iItem = 6;
	lvi.pszText = (LPSTR)(LPCTSTR)str;
	lvi.lParam = BLOCK_MONSTER1;
	lvi.iImage = 23;
	pList->InsertItem (&lvi);

	str.LoadString (IDS_BLOCK_HEART);
	lvi.iItem = 7;
	lvi.pszText = (LPSTR)(LPCTSTR)str;
	lvi.lParam = BLOCK_MONSTER2;
	lvi.iImage = 27;
	pList->InsertItem (&lvi);

	SetSelectedBlock (0);
}

/////////////////////////////////////////////////////////////////////////////
CComboBox*	CBoulderEditBar::GetLevelList ()
{
	return (CComboBox*)GetDlgItem (IDC_EB_COMBO);
}

/////////////////////////////////////////////////////////////////////////////
int CBoulderEditBar::GetSelectedBlock ()
{
	CListCtrl* pList = ((CListCtrl*)GetDlgItem (IDC_EB_LIST));

	POSITION pos = pList->GetFirstSelectedItemPosition();
	int nItem = -1;
	
	if (pos)
		nItem = pList->GetNextSelectedItem(pos);

	if (nItem != -1)
		return pList->GetItemData (nItem);
	else
		return BLOCK_NULL;
}

/////////////////////////////////////////////////////////////////////////////
void CBoulderEditBar::SetSelectedBlock (int index)
{
	CListCtrl* pList = ((CListCtrl*)GetDlgItem (IDC_EB_LIST));

	pList->SetItemState (index, LVIS_SELECTED, LVIS_SELECTED);
	pList->EnsureVisible (index, FALSE);
	
	int i = GetSelectedBlock ();
}

/////////////////////////////////////////////////////////////////////////////
int CBoulderEditBar::GetSelectedLevel ()
{
	CComboBox* pCombo = ((CComboBox*)GetDlgItem (IDC_EB_COMBO));
	return (pCombo->GetItemData (pCombo->GetCurSel ()));
}

/////////////////////////////////////////////////////////////////////////////
int CBoulderEditBar::IndexToBlock (int index)
{
	CListCtrl* pList = ((CListCtrl*)GetDlgItem (IDC_EB_LIST));

	return pList->GetItemData (index);
}

int CBoulderEditBar::BlockToIndex (int block)
{
	CListCtrl* pList = ((CListCtrl*)GetDlgItem (IDC_EB_LIST));

	int nItems = pList->GetItemCount ();
	for (int i = 0; i < nItems; i++)
		if (pList->GetItemData (i) == block)
			return i;

	return -1;
}

/////////////////////////////////////////////////////////////////////////////
void CBoulderEditBar::OnEbNormal ()
{
	m_nTool = EDIT_TOOL_NORMAL;
	m_pMessageSink->SetFocus ();
}

/////////////////////////////////////////////////////////////////////////////
void CBoulderEditBar::OnEbLine ()
{
	m_nTool = EDIT_TOOL_LINE;
	m_pMessageSink->SetFocus ();
}

/////////////////////////////////////////////////////////////////////////////
void CBoulderEditBar::OnEbPaint ()
{
	m_nTool = EDIT_TOOL_PAINT;
	m_pMessageSink->SetFocus ();
}

/////////////////////////////////////////////////////////////////////////////
void CBoulderEditBar::OnEbFill ()
{
	m_nTool = EDIT_TOOL_FILL;
	m_pMessageSink->SetFocus ();
}

/////////////////////////////////////////////////////////////////////////////
void CBoulderEditBar::OnEbComboClose ()
{
	m_pMessageSink->SetFocus ();
}

BOOL CBoulderEditBar::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult) 
{
	if (wParam == IDC_EB_LIST)
	{
		if (((NMHDR*)lParam)->code == LVN_ITEMCHANGED)
			m_pMessageSink->SetFocus ();
	}
	
	return CDialogBar::OnNotify(wParam, lParam, pResult);
}
