// BlockMonster.h: interface for the CBlockMonster class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BLOCKMONSTER_H__6EDAE405_6630_11D5_874B_00A0C9697DFA__INCLUDED_)
#define AFX_BLOCKMONSTER_H__6EDAE405_6630_11D5_874B_00A0C9697DFA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "MapBlock.h"
#include "BlockDinamic.h"

class CBlockMonster : public CBlockDinamic  
{
	int					m_type;
	BOOL				m_bInverceXAxis;
	BOOL				m_bInverceYAxis;
	int					m_oldMovement;

public:
	CBlockMonster(int type);
	virtual ~CBlockMonster();

	virtual int			GetBlockType (){return BLOCK_MONSTER;}
	virtual void		IncreaseState ();
	virtual void		DrawBlock (CDC* pDc, CPoint ptPos, BOOL bDrawAllMap = TRUE);

	int					GetMonsterType (){return m_type;}
	void				EnableInverceByXAxis (BOOL bInverce){m_bInverceXAxis = bInverce;}
	void				EnableInverceByYAxis (BOOL bInverce){m_bInverceYAxis = bInverce;}
	BOOL				IsInverceByXAxis (){return m_bInverceXAxis;}
	BOOL				IsInverceByYAxis (){return m_bInverceYAxis;}
	void				SetOldMovement (int movement){m_oldMovement = movement;}
	int					GetOldMovement (){return m_oldMovement;}
};

#endif // !defined(AFX_BLOCKMONSTER_H__6EDAE405_6630_11D5_874B_00A0C9697DFA__INCLUDED_)
