/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: WindowMode.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// WindowMode.h: interface for the CWindowMode class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_WINDOWMODE_H__B49CE94D_D38D_489A_997C_ED11D29E0776__INCLUDED_)
#define AFX_WINDOWMODE_H__B49CE94D_D38D_489A_997C_ED11D29E0776__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Screen.h"
#include "Board.h"

/////////////////////////////////////////////////////////////////////////////
class CWindowMode
{
	CScreen*			m_pScreen;
	CMotherBoard*		m_pMotherBoard;
	BOOL				m_bFullscreenMode;

public:
	CWindowMode (CScreen* pScreen, CMotherBoard* pMotherBoard);
	~CWindowMode ();

	void				SetScreen (CScreen* pScreen) {m_pScreen = pScreen;}
	void				SetMotheboard (CMotherBoard* pMotherBoard) {m_pMotherBoard = pMotherBoard;}
};

#endif // !defined(AFX_WINDOWMODE_H__B49CE94D_D38D_489A_997C_ED11D29E0776__INCLUDED_)
