/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: TapeUnit.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// TapeUnit.h: interface for the CTapeUnit class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TAPEUNIT_H__16BDA7EC_9F22_4A26_977C_F6CEDDDF03DD__INCLUDED_)
#define AFX_TAPEUNIT_H__16BDA7EC_9F22_4A26_977C_F6CEDDDF03DD__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//////////////////////////////////////////////////////////////////////
class CTapeUnit  
{
	enum				{UNKNOWN = -1};

	int					m_type;
	int					m_address;
	int					m_length;
	int					m_msTime;
	int					m_waveLength;
	BOOL				m_bCRC;
	CString				m_strName;
	CString				m_strPath;

	BOOL				IsFileWave (CString strPath);
	BOOL				IsFileMSF (CString strPath);
	BOOL				IsFileBin (CString strPath);

public:
	enum				{TYPE_NONE = -1, TYPE_BIN = 0, TYPE_WAV, TYPE_MSF, TYPE_TMP};

	CTapeUnit ();
	CTapeUnit (CTapeUnit& tapeUnit);
	virtual ~CTapeUnit ();

	CTapeUnit&			operator= (CTapeUnit& tapeUnit);

	BOOL				SetFile (CString strPath);
	BOOL				SetTmpFile (CString strPath);

	int					GetType () {return m_type;}
	int					GetAddress () {return m_address;}
	int					GetLength () {return m_length;}
	int					GetTime () {return m_msTime;}
	int					GetWaveLength () {return m_waveLength;}
	BOOL				GetCRC () {return m_bCRC;}
	CString				GetName () {return m_strName;}
	CString				GetPath () {return m_strPath;}

	BOOL				RetrieveInfo ();
	BOOL				SaveAs (CString strPath, int type);
};

#endif // !defined(AFX_TAPEUNIT_H__16BDA7EC_9F22_4A26_977C_F6CEDDDF03DD__INCLUDED_)
