/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: TapeManagerDlg.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




#if !defined(AFX_TAPEMANAGERDLG_H__E4AFA0DE_9EC0_4539_A4E1_2B2E58797E46__INCLUDED_)
#define AFX_TAPEMANAGERDLG_H__E4AFA0DE_9EC0_4539_A4E1_2B2E58797E46__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// TapeManagerDlg.h : header file
//

#include <afxmt.h>
#include <mmsystem.h>
#include <dsound.h>

#include "DST.h"
#include "Defines.h"
#include "Tape.h"
#include "TapeUnit.h"

/////////////////////////////////////////////////////////////////////////////
// CTapeManagerDlg dialog

class CTapeManagerDlg : public CBKDialog
{
	enum				{CTRL_UPDATE_TIMER = 0};

	enum				{BUFFER_FREQUENCY = 44100};
	enum				{BUFFER_BPS = 8};
	enum				{EVENTS_NUM = 2};
	enum				{CAPTURE_BUFFERS_NUM = 10};
	enum				{OUTSTRINGS_COUNT = 300};
	enum				{SILENCE_LENGTH = BUFFER_FREQUENCY / 10};
	enum				{SILENCE_THRESHOLD = 32};

	CComPtr<IDirectSoundCapture>		m_pDirectSoundCapture;
	CComPtr<IDirectSoundCaptureBuffer> m_pCaptureBuffer;
	CComPtr<IDirectSoundNotify> m_pNotify;
	DSBPOSITIONNOTIFY*	m_pNotifyPositions;
	HANDLE*				m_pNotifyEvents;
	HANDLE				m_hBufferReadyEvent;
	CCriticalSection	m_csModifyBuffer;

	CWinThread*			m_pNotifyThread;
	
	BOOL				m_bBufferReady;
	CList <BYTE*, BYTE*>m_captureBuffers;
	
	DSCBUFFERDESC       m_BD;
	WAVEFORMATEX		m_wfx;

	int					m_nOutStringsCount;
	CStringList			m_outStrings;

	BOOL				m_bCaptureMode;
	DWORD				m_captureOffset;
	DWORD				m_captureLength;
	int					m_nHeaderBuffer;
	CTape				m_headReader;
	CFile				m_captureFile;
	CString				m_strCaptureFileName;
	BYTE				m_captureBuffer[BUFFER_FREQUENCY / EVENTS_NUM];

	enum				{COLUMN_TYPE = 0, COLUMN_NAME, COLUMN_ADDR, COLUMN_LEN
						, COLUMN_TIME, COLUMN_WAVELEN, COLUMN_CRC, COLUMN_PATH};

	CImageList			m_imgList;
	CWinThread*			m_pStatusThread;
	HANDLE				m_hStatusExit;
	HANDLE				m_hStatusNew;
	CTape				m_statusReader;
	CCriticalSection	m_csModifyStatus;
	
	//typedef CList <CTapeUnit, CTapeUnit&> CTapeUnitList;

	int					m_tapePos;
	int					m_tapeCount;
	//CTapeUnitList		m_tapeList;
	CTapeUnit*			m_pTapeUnit;

	enum				{COMBO_NONE = 0, COMBO_SAVE_AS_MSF, COMBO_SAVE_AS_WAV, COMBO_SAVE_AS_BIN};

	CString				m_strCurrentFolder;
	
	// Capture methods
	BOOL				InitDirectSound ();
	void				InitEvents ();
	void				InitBuffers ();
	void				RemoveBuffers ();

	static int			EventThreadWrapper (CTapeManagerDlg* pThis);
	void				EventThread ();
	static int			StatusThreadWrapper (CTapeManagerDlg* pThis);
	void				StatusThread ();

	BOOL				WaitForBufferReady (int time = INFINITE);
	DWORD				GetAllBuffersLength ();
	void				GetAllBuffers (BYTE* pBuffer);
	DWORD				GetBufferLength ();
	void				GetBuffer (BYTE* pBuffer);
	void				ClearBuffers ();

	void				DebugDraw ();
	void				OutString (CString strOut);

	CString				GetTmpFilePath ();
	BOOL				WriteBuffer (BYTE* pBuff, DWORD nSize);
	BOOL				IsCaptureEnd (BYTE* pBuff, DWORD nSize);

	// Get file status methods
	void				InitListCtrl ();
	void				InitComboCtrl ();
	void				InsertNewUnit (CTapeUnit* pUnit);
	void				RetrieveInfo (CTapeUnit* pUnit);
	void				FileListChanged (int nTapeCount);
	void				SetFolder (CString strFolder);
	void				DeleteUnits (BOOL bSelected);
	void				SaveUnitsAs (int type);

// Construction
public:
	CTapeManagerDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CTapeManagerDlg ();

// Dialog Data
	//{{AFX_DATA(CTapeManagerDlg)
	enum { IDD = IDD_TAPE_MANAGER };
	CListCtrl	m_list;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTapeManagerDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CTapeManagerDlg)
	virtual BOOL OnInitDialog();
	afx_msg HRESULT OnBufferReady (WPARAM wParam, LPARAM lParam);
	afx_msg HRESULT OnInfoReady (WPARAM wParam, LPARAM lParam);
	afx_msg void OnTmLoad();
	afx_msg void OnGetdispinfoTmList(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnTmBrowse();
	virtual void OnCancel();
	afx_msg void OnTmRemove();
	afx_msg void OnUpdateTmRemove (CCmdUI* pCmdUI);
	afx_msg void OnSelendokTmSaveAs();
	afx_msg void OnUpdateSelendokTmSaveAs (CCmdUI* pCmdUI);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnRclickTmList(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnTmSelectall();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TAPEMANAGERDLG_H__E4AFA0DE_9EC0_4539_A4E1_2B2E58797E46__INCLUDED_)
