/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: TapeControlDlg.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




#if !defined(AFX_TAPECONTROLDLG_H__58B95A23_8946_40A3_BA3B_857C7C57361A__INCLUDED_)
#define AFX_TAPECONTROLDLG_H__58B95A23_8946_40A3_BA3B_857C7C57361A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// TapeControlDlg.h : header file
//

#include "BKDialog.h"

class CTape;
class CScreen;
class CMotherBoard;

/////////////////////////////////////////////////////////////////////////////
// CTapeControlDlg dialog

/////////////////////////////////////////////////////////////////////////////
class CTapeControlDlg : public CBKDialog
{
	CTape*				m_pTape;
	CScreen*			m_pScreen;
	CMotherBoard*		m_pMotherboard;

	void				ShowSaveDialog ();

// Construction
public:
	CTapeControlDlg (CTape* pTape = NULL, CWnd* pParent = NULL);   // standard constructor

	CString				m_strTapePath;

	void				SetTape (CTape* pTape) {m_pTape = pTape;}
	void				SetScreen (CScreen* pScreen) {m_pScreen = pScreen;}
	void				SetMotheboard (CMotherBoard* pMotherBoard) {m_pMotherboard = pMotherBoard;}
	void				PressRecordButton ();

// Dialog Data
	//{{AFX_DATA(CTapeControlDlg)
	enum { IDD = IDD_TAPE_CONTROL };
	BOOL	m_bAutoBeginDetection;
	BOOL	m_bAutoEnddetection;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTapeControlDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CTapeControlDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnTcRecord();
	afx_msg void OnTcStop();
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TAPECONTROLDLG_H__58B95A23_8946_40A3_BA3B_857C7C57361A__INCLUDED_)
