/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: TapeControlDlg.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// TapeControlDlg.cpp : implementation file
//

#include "stdafx.h"
#include "bk.h"
#include "defines.h"
#include "globals.h"
#include "TapeControlDlg.h"
#include "Tape.h"
#include "WindowMode.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTapeControlDlg dialog


CTapeControlDlg::CTapeControlDlg(CTape* pTape, CWnd* pParent /*=NULL*/)
	: CBKDialog(CTapeControlDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTapeControlDlg)
	m_bAutoBeginDetection = FALSE;
	m_bAutoEnddetection = FALSE;
	//}}AFX_DATA_INIT

	m_pTape = pTape;
}


void CTapeControlDlg::DoDataExchange(CDataExchange* pDX)
{
	CBKDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTapeControlDlg)
	DDX_Check(pDX, IDC_TC_AUTOBEGIN, m_bAutoBeginDetection);
	DDX_Check(pDX, IDC_TC_AUTOEND, m_bAutoEnddetection);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTapeControlDlg, CBKDialog)
	//{{AFX_MSG_MAP(CTapeControlDlg)
	ON_BN_CLICKED(IDC_TC_RECORD, OnTcRecord)
	ON_BN_CLICKED(IDC_TC_STOP, OnTcStop)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTapeControlDlg message handlers

BOOL CTapeControlDlg::OnInitDialog() 
{
	CBKDialog::OnInitDialog();
	
	((CButton*)GetDlgItem (IDC_TC_RECORD))->SetIcon (::LoadIcon (AfxGetInstanceHandle (), MAKEINTRESOURCE (IDI_TCTRL_RECORD)));
	((CButton*)GetDlgItem (IDC_TC_STOP))->SetIcon (::LoadIcon (AfxGetInstanceHandle (), MAKEINTRESOURCE (IDI_TCTRL_STOP)));
	
	UpdateData (FALSE);

	SetTimer (0, 300, NULL);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}



/////////////////////////////////////////////////////////////////////////////
void CTapeControlDlg::OnTcRecord() 
{
	UpdateData (TRUE);

	if (IsDlgButtonChecked (IDC_TC_RECORD))
		m_pTape->StartRecord (m_bAutoBeginDetection, m_bAutoEnddetection);
	else
	{
		m_pTape->StopRecord ();

		ShowSaveDialog ();
	}
		
	GetParent ()->SetFocus ();
}



/////////////////////////////////////////////////////////////////////////////
void CTapeControlDlg::OnTcStop() 
{
	if (((CButton*)GetDlgItem (IDC_TC_RECORD))->GetCheck ())
		((CButton*)GetDlgItem (IDC_TC_RECORD))->SetCheck (0);
	
	if (m_pTape->IsPlaying ())
		m_pTape->StopPlay ();

	if (m_pTape->IsRecording ())
	{
		m_pTape->StopRecord ();
		ShowSaveDialog ();
	}
}



/////////////////////////////////////////////////////////////////////////////
void CTapeControlDlg::OnTimer(UINT nIDEvent) 
{
	if (nIDEvent == 0)
	{
		BOOL bPress = ((CButton*)GetDlgItem (IDC_TC_RECORD))->GetCheck ();

		if (bPress && m_pTape && (!m_pTape->IsRecording ()))
		{
			((CButton*)GetDlgItem (IDC_TC_RECORD))->SetCheck (0);
			OnTcRecord ();
		}
	}
	
	CBKDialog::OnTimer(nIDEvent);
}



/////////////////////////////////////////////////////////////////////////////
void CTapeControlDlg::ShowSaveDialog ()
{
	CWindowMode mode(m_pScreen, m_pMotherboard);

	CString strFilterTape;
	strFilterTape.LoadString (IDS_FILEFILTER_TAPE);
	CString strWaveExt;
	strWaveExt.LoadString (IDS_FILEEXT_WAVE);
	CString strTapeExt;
	strTapeExt.LoadString (IDS_FILEEXT_TAPE);

	CBKFileDialog dlg (FALSE, strTapeExt, NULL, 
		OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,
		strFilterTape, this);

	dlg.m_ofn.lpstrInitialDir = m_strTapePath;

	if (dlg.DoModal () == IDOK)
	{
		CString strFilePath = dlg.GetPathName ();
		CString strExt = GetFileExt (strFilePath);
		
		if (strExt == strWaveExt)
			m_pTape->SaveWaveFile (strFilePath);
		else
			m_pTape->SaveMSFFile (strFilePath);
	}

	m_strTapePath = GetFilePath (dlg.GetPathName ());
}



/////////////////////////////////////////////////////////////////////////////
void CTapeControlDlg::PressRecordButton ()
{
	SendDlgItemMessage (IDC_TC_RECORD, BM_CLICK);
}