/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: Tape.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// Tape.h: interface for the CTape class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TAPE_H__A890DD5A_20F8_49D1_9335_E0CEB8F498F0__INCLUDED_)
#define AFX_TAPE_H__A890DD5A_20F8_49D1_9335_E0CEB8F498F0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <mmsystem.h>

//////////////////////////////////////////////////////////////////////
struct TAPE_FILE_INFO
{
	DWORD				start_tuning;
	DWORD				synchro_start;
	DWORD				marker1;
	DWORD				synchro_header;
	DWORD				header;
	WORD				address;
	WORD				length;
	BYTE				name[16];
	DWORD				marker2;
	DWORD				synchro_data;
	DWORD				data;
	WORD				crc;
	DWORD				synchro6;
	DWORD				end_tuning;
	DWORD				end;
};



//////////////////////////////////////////////////////////////////////
class CTape  
{
	BOOL				m_bPlay;
	BYTE*				m_pWave;
	DWORD				m_waveLength;
	DWORD				m_play_pos;

	BOOL				m_bRecord;
	BYTE*				m_pRecord;
	DWORD				m_record_pos;
	DWORD				m_recordLength;
	BOOL				m_bAutoBeginRecord;
	BOOL				m_bAutoEndRecord;

	BYTE*				m_pBin;
	
	DWORD				m_pos;
	DWORD				m_average;
	int					m_last_len;
	int					m_avg_length;

	BYTE*				m_pPackBits;
	DWORD				m_bitsLength;

	WORD*				m_pPackLZW;
	DWORD				m_lzwLength;

	enum				{RECORD_BUFFER = 4 * 1024 * 1024};
	enum				{RECORD_GROW = 2 * 1024 * 1024};
	enum				{BAD_CODE = 65535};
	enum				{RESET_CODE = 256};
	enum				{PREFIX = 256};
	enum				{CODE = 257};
	enum				{MAX_TABLE_SIZE = 65000};
	
	WORD*				m_scan_table[MAX_TABLE_SIZE];
	int					m_table_size;

	void				InitTables ();
	void				ClearTables ();
	int					TableLookup_Fast (WORD prefix, int end_pos);
	void				AddWord_Fast (WORD prefix, int end_pos);
	BOOL				UnpackWord (int code);


	enum				{BAD_LENGTH = -1};

	BOOL				FindTuning (int length, DWORD& wave_pos, int& wave_length);
	BOOL				FindSyncro ();
	BOOL				FindSyncro6 ();
	int					CalcImpLength (BYTE* pWave, DWORD& pos, DWORD length);
	int					DefineLength (int length);
	BOOL				ReadBit (BOOL& bBit);
	BOOL				ReadByte (BYTE& byte);

	BOOL				SaveTuning (int length);
	BOOL				SaveSyncro ();
	BOOL				SaveSyncro6 ();
	BOOL				SaveImp (int size);
	BOOL				SaveBit (BOOL bBit);
	BOOL				SaveByte (BYTE byte);

	BOOL				FindRecordBegin (DWORD buffLength);
	BOOL				FindRecordEnd ();

public:
	CTape();
	virtual ~CTape();

	// Wave pack/unpack methods
	DWORD				PackBits ();
	void				UnpackBits ();
	
	DWORD				PackLZW_Fast ();
	void				UnpackLZW_Fast ();

	// Wave read/write methods
	BOOL				SetWaveFile (TAPE_FILE_INFO* pTfi);
	BOOL				GetWaveFile (TAPE_FILE_INFO* pTfi, BOOL bHeaderOnly = FALSE);
	BOOL				CalcCRC (TAPE_FILE_INFO* pTfi, BOOL bCheck);

	BOOL				LoadWaveFile (CString strPath);
	BOOL				SaveWaveFile (CString strPath);

	BOOL				LoadBinFile (CString strPath, TAPE_FILE_INFO* pTfi);
	BOOL				SaveBinFile (CString strPath, TAPE_FILE_INFO* pTfi);

	BOOL				LoadMSFFile (CString strPath);
	BOOL				SaveMSFFile (CString strPath);

	BOOL				LoadTmpFile (CString strPath);

	// Wave buffer methods
	BOOL				AllocWaveBuffer (DWORD nSize);
	BOOL				LoadBuffer (BYTE* pBuff, DWORD nSize);
	DWORD				GetWaveLength ();
	BYTE*				GetWaveBuffer () {return m_pWave;}

	// Playing methods
	void				SetPlayWavePos (DWORD play_pos);
	void				PlayWaveGetBuffer (BYTE* pBuff, int buffLength);
	
	DWORD				GetPlayWavePos ();
	void				StartPlay ();
	void				StopPlay ();
	BOOL				IsPlaying () {return m_bPlay;}
	void				StartRecord (BOOL bAutoBeginRecord, BOOL bAutoEndRecord);
	void				RecordWaveGetBuffer (BYTE* pBuff, int buffLength);
	void				StopRecord ();
	BOOL				IsRecording () {return m_pRecord != NULL;}
};

#endif // !defined(AFX_TAPE_H__A890DD5A_20F8_49D1_9335_E0CEB8F498F0__INCLUDED_)
