/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: StaticLink.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// StaticLink.cpp : implementation file
//

#include "stdafx.h"
#include "bk.h"
#include "StaticLink.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStaticLink

CStaticLink::CStaticLink()
{
	m_bUnderline = FALSE;
}

CStaticLink::~CStaticLink()
{
}


BEGIN_MESSAGE_MAP(CStaticLink, CStatic)
	//{{AFX_MSG_MAP(CStaticLink)
	ON_WM_CTLCOLOR_REFLECT()
	ON_WM_MOUSEMOVE()
	ON_WM_TIMER()
	ON_CONTROL_REFLECT(BN_CLICKED, OnClicked)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStaticLink message handlers


/////////////////////////////////////////////////////////////////////////////
void CStaticLink::PreSubclassWindow() 
{
	ModifyStyle (0, SS_NOTIFY);
	SetTimer (0, 100, NULL);

	CStatic::PreSubclassWindow();
}



/////////////////////////////////////////////////////////////////////////////
HBRUSH CStaticLink::CtlColor(CDC* pDC, UINT nCtlColor) 
{
	pDC->SetTextColor (::GetSysColor (COLOR_HIGHLIGHT));
	pDC->SetBkColor (::GetSysColor (COLOR_BTNFACE));

	LOGFONT log;
	GetFont ()->GetLogFont (&log);
		
	log.lfUnderline = m_bUnderline;
	
	CFont font;
	font.CreateFontIndirect (&log);

	pDC->SelectObject (&font);
	//pOldFont->DeleteObject ();
	//delete pOldFont;

	// transparent text.
	//pDC->SetBkMode (TRANSPARENT);

	return (HBRUSH)GetStockObject (NULL_BRUSH);
}



/////////////////////////////////////////////////////////////////////////////
void CStaticLink::OnMouseMove(UINT nFlags, CPoint point) 
{
	m_bUnderline = TRUE;

	Invalidate (TRUE);
	
	CStatic::OnMouseMove(nFlags, point);
}



/////////////////////////////////////////////////////////////////////////////
void CStaticLink::OnTimer(UINT nIDEvent) 
{
	CPoint ptCursor;
	GetCursorPos (&ptCursor);

	CRect rcClient;
	GetClientRect (&rcClient);
	ClientToScreen (&rcClient);

	if (rcClient.PtInRect (ptCursor))
		m_bUnderline = TRUE;
	else
		m_bUnderline = FALSE;
	
	Invalidate (TRUE);	

	CStatic::OnTimer(nIDEvent);
}



/////////////////////////////////////////////////////////////////////////////
void CStaticLink::OnClicked() 
{
	CString strURL;
	GetWindowText (strURL);

	ShellExecute (NULL, _T("open"), strURL, NULL,NULL, SW_SHOW);
}
