/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: Splitter.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




#if !defined(AFX_SPLITTER_H__FFB1A2A9_0C0E_4427_BB98_2D173F69D0DD__INCLUDED_)
#define AFX_SPLITTER_H__FFB1A2A9_0C0E_4427_BB98_2D173F69D0DD__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// Splitter.h : header file
//

#include "PanelBackground.h"
class CPanel;

//////////////////////////////////////////////////////////////////////
#define DEFAULT_SPLITTER_WIDTH 6

/////////////////////////////////////////////////////////////////////////////
// CSplitter window
/////////////////////////////////////////////////////////////////////////////
class CSplitter : public CPanelBackground
{
	enum {ALIGN_NOWHERE = -1, ALIGN_RIGHT = 0, ALIGN_LEFT, ALIGN_BOTTOM, ALIGN_TOP};

	BOOL				m_bMoveSplitter;
	CPoint				m_ptInitPos;
	CPoint				m_ptOldPos;
	CPoint				m_ptEndPos;

// Construction
public:
	CSplitter();

// Attributes
public:

// Operations
public:

	void				DrawDragMark (CPoint& ptPos);
	void				RepositionPanel (CPoint& ptPos);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSplitter)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CSplitter();

	// Generated message map functions
protected:
	//{{AFX_MSG(CSplitter)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnCaptureChanged(CWnd *pWnd);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SPLITTER_H__FFB1A2A9_0C0E_4427_BB98_2D173F69D0DD__INCLUDED_)
