/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: Splitter.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// Splitter.cpp : implementation file
//

#include "stdafx.h"
#include "Splitter.h"
#include "Panel.h"
#include "resource.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSplitter

CSplitter::CSplitter()
{
	m_bMoveSplitter = FALSE;
}

CSplitter::~CSplitter()
{
}


BEGIN_MESSAGE_MAP(CSplitter, CPanelBackground)
	//{{AFX_MSG_MAP(CSplitter)
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_CAPTURECHANGED()
	ON_WM_LBUTTONUP()
	ON_WM_SETCURSOR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSplitter message handlers


/////////////////////////////////////////////////////////////////////////////
void CSplitter::DrawDragMark (CPoint& ptPos)
{
	CPoint pt (ptPos);
	
	ClientToScreen (&pt);
	
	CRect rcWindow;
	GetWindowRect (&rcWindow);
	
	// Restrict spliter cursor rect
	CRect rcBase;
	m_pPanel->GetBase ()->GetWindowRect (&rcBase);

	pt.x = max (rcBase.left, min (rcBase.right - DEFAULT_SPLITTER_WIDTH, pt.x));
	pt.y = max (rcBase.top, min (rcBase.bottom - DEFAULT_SPLITTER_WIDTH, pt.y));

	// Calculate cursor coordinates
	switch (m_pPanel->GetAlign ())
	{
	case ALIGN_LEFT:
	case ALIGN_RIGHT:
		rcWindow.left = pt.x;
		rcWindow.right = rcWindow.left + DEFAULT_SPLITTER_WIDTH;
		break;
	case ALIGN_TOP:
	case ALIGN_BOTTOM:
		rcWindow.top = pt.y;
		rcWindow.bottom = rcWindow.top + DEFAULT_SPLITTER_WIDTH;
		break;
	default:
		ASSERT (FALSE);
	}
		
	// Draw cursor
	CWnd* pWnd = CWnd::GetDesktopWindow ();
	CDC* pDC = pWnd->GetDCEx (NULL, DCX_WINDOW|DCX_CACHE|DCX_LOCKWINDOWUPDATE);

	CBrush* pBr = (CBrush*)CDC::GetHalftoneBrush ();
	CBrush* pOld = (CBrush*)pDC->SelectObject (pBr);
	pDC->PatBlt (rcWindow.left, rcWindow.top, rcWindow.Width (), rcWindow.Height (), PATINVERT);
	pDC->SelectObject (pOld);
}



/////////////////////////////////////////////////////////////////////////////
void CSplitter::OnLButtonDown(UINT nFlags, CPoint point) 
{
	m_bMoveSplitter = TRUE;
	m_ptInitPos = point;
	m_ptOldPos = point;

	// Lock windows update while dragging
	CWnd* pWnd = CWnd::GetDesktopWindow ();
	pWnd->LockWindowUpdate ();

	// Draw dragging frame
	DrawDragMark (point);
	SetCapture ();
	
	CPanelBackground::OnLButtonDown(nFlags, point);
}



/////////////////////////////////////////////////////////////////////////////
void CSplitter::OnMouseMove(UINT nFlags, CPoint point) 
{
	if (m_bMoveSplitter)
	{
		DrawDragMark (m_ptOldPos);
		m_ptOldPos = point;
		
		DrawDragMark (point);
	}
	
	CPanelBackground::OnMouseMove(nFlags, point);
}



/////////////////////////////////////////////////////////////////////////////
void CSplitter::OnLButtonUp(UINT nFlags, CPoint point) 
{
	m_ptEndPos = point;
	ReleaseCapture ();
	
	CPanelBackground::OnLButtonUp(nFlags, point);
}



/////////////////////////////////////////////////////////////////////////////
void CSplitter::OnCaptureChanged(CWnd *pWnd) 
{
	if (m_bMoveSplitter)
	{
		DrawDragMark (m_ptOldPos);
		m_bMoveSplitter = FALSE;

		CWnd* pWnd = CWnd::GetDesktopWindow ();
		pWnd->UnlockWindowUpdate ();

		RepositionPanel (m_ptEndPos);
	}
	
	CPanelBackground::OnCaptureChanged(pWnd);
}



/////////////////////////////////////////////////////////////////////////////
void CSplitter::RepositionPanel (CPoint& ptPos)
{
	CRect rcParent;
	GetParent ()->GetClientRect (&rcParent);

	//CPoint ptScreen (ptPos);
	//ClientToScreen (&ptScreen);
	//GetParent ()->ScreenToClient (&ptScreen);
	
	/*
	if (ptScreen.x < 0)
		ptScreen.x = 0;

	if (ptScreen.x > rcParent.Width () - DEFAULT_SPLITTER_WIDTH)
		ptScreen.x = rcParent.Width () - DEFAULT_SPLITTER_WIDTH;

	if (ptScreen.y < 0)
		ptScreen.y = 0;

	if (ptScreen.y > rcParent.Height () - DEFAULT_SPLITTER_WIDTH)
		ptScreen.y = rcParent.Height () - DEFAULT_SPLITTER_WIDTH;
	*/

	CSize szParent = m_pPanel->GetParent ()->GetParent ()->GetRect ().Size ();

	//GetParent ()->ClientToScreen (&ptScreen);
	//ScreenToClient (&ptScreen);
	//ptScreen += m_ptInitPos;
	
	//CPoint ptOffs (ptScreen);
	CPoint ptOffs (ptPos);
	ptOffs -= m_ptInitPos;

	switch (m_pPanel->GetAlign ())
	{
		case ALIGN_LEFT:
		{
			if (-ptOffs.x >= szParent.cx)
				ptOffs.x = -szParent.cx;

			int width = m_pPanel->GetParent ()->GetFixedWidth () - ptOffs.x;

			if (width < DEFAULT_SPLITTER_WIDTH)
				width = DEFAULT_SPLITTER_WIDTH;

			m_pPanel->GetParent ()->SetFixedWidth (width);
		}
		break;
		case ALIGN_RIGHT:
		{
			if (ptOffs.x >= szParent.cx)
				ptOffs.x = szParent.cx;

			int width = m_pPanel->GetParent ()->GetFixedWidth () + ptOffs.x;

			if (width < DEFAULT_SPLITTER_WIDTH)
				width = DEFAULT_SPLITTER_WIDTH;

			m_pPanel->GetParent ()->SetFixedWidth (width);
		}
		break;

		case ALIGN_TOP:
		{
			if (-ptOffs.y >= szParent.cy)
				ptOffs.y = -szParent.cy;

			int height = m_pPanel->GetParent ()->GetFixedHeight () - ptOffs.y;

			if (height < DEFAULT_SPLITTER_WIDTH)
				height = DEFAULT_SPLITTER_WIDTH;

			m_pPanel->GetParent ()->SetFixedHeight (height);
		}
		break;

		case ALIGN_BOTTOM:
		{
			if (ptOffs.y >= szParent.cy)
				ptOffs.y = szParent.cy;

			int height = m_pPanel->GetParent ()->GetFixedHeight () + ptOffs.y;
			
			if (height < DEFAULT_SPLITTER_WIDTH)
				height = DEFAULT_SPLITTER_WIDTH;

			m_pPanel->GetParent ()->SetFixedHeight (height);
		}
		break;
	}
		
	GetParent ()->SendMessage (WM_SIZE, 0, MAKELPARAM (rcParent.Width (), rcParent.Height ()));
	GetParent ()->Invalidate (FALSE);
}



/////////////////////////////////////////////////////////////////////////////
BOOL CSplitter::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	switch (m_pPanel->GetAlign ())
	{
		case ALIGN_LEFT:
		case ALIGN_RIGHT:
			SetCursor (::LoadCursor (AfxGetInstanceHandle (), MAKEINTRESOURCE (IDC_HSPLITTER)));
			return TRUE;
		case ALIGN_TOP:
		case ALIGN_BOTTOM:
			SetCursor (::LoadCursor (AfxGetInstanceHandle (), MAKEINTRESOURCE (IDC_VSPLITTER)));
			return TRUE;
	}
	
	return CPanelBackground::OnSetCursor(pWnd, nHitTest, message);
}
