/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: Speaker.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// Speaker.h: interface for the CSpeaker class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SPEAKER_H__C5707DC2_23D7_4893_82BC_9817200B2907__INCLUDED_)
#define AFX_SPEAKER_H__C5707DC2_23D7_4893_82BC_9817200B2907__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Device.h"

//////////////////////////////////////////////////////////////////////
class CSpeaker : public CDevice  
{
protected:
	enum				{DEFAULT_SIZE = 1024 * 1014};
	enum				{MIN_SAMPLE = 0, MAX_SAMPLE = 255};

	BOOL				m_bEnableSound;
	BYTE*				m_pSamples;
	int					m_nSampleCount;
	BYTE				m_lastSample;
	LONGLONG			m_lastTick;
	BYTE*				m_pRecieveSamples;
	int					m_ips;
	
	void				SetSample (BYTE sample);

public:
	CSpeaker();
	virtual ~CSpeaker();

	void				SetIPS (int ips);
	int					GetSampleCount ();
	void				GetAndRemoveSamples (BYTE* pBuff, int length);
	void				MixAndRemoveSamples (BYTE* pBuff, int length);
	void				EnableSound (BOOL bEnable);
	BOOL				IsSoundEnabled ();
	void				ReceiveSamples (BYTE* pBuff, int length);

	// Virtual method called after reset command
	virtual void		OnReset ();

	// Methods for Set/Get byte/word
	virtual void		GetByte (int addr, BYTE* pValue);
	virtual void		GetWord (int addr, WORD* pValue);
	virtual void		SetByte (int addr, BYTE value);
	virtual void		SetWord (int addr, WORD value);
};

#endif // !defined(AFX_SPEAKER_H__C5707DC2_23D7_4893_82BC_9817200B2907__INCLUDED_)
