/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: ScriptRunner.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// ScriptRunner.h: interface for the CScriptRunner class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SCRIPTRUNNER_H__07726496_4736_4704_A65C_EC16DFA8E0E5__INCLUDED_)
#define AFX_SCRIPTRUNNER_H__07726496_4736_4704_A65C_EC16DFA8E0E5__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CMotherBoard;

//////////////////////////////////////////////////////////////////////
class CScriptRunner  
{
	CMotherBoard*		m_pChip;

	CStdioFile			m_fileScript;
	CString				m_strScriptFileName;
	CString				m_strScriptLine;
	int					m_nScriptLinePos;
	DWORD				m_scriptCurrTick;
	double				m_scriptStartDelay;
	BOOL				m_bRus;

public:
	CScriptRunner();
	virtual ~CScriptRunner();

	void				AttachChip (CMotherBoard* pChip) {m_pChip = pChip;}

	void				SetScriptPath (CString strScriptPath);
	BOOL				RunScript ();
	void				ParseNextChar (TCHAR ch);
	void				SendNewCharToBK (TCHAR ch);
};

#endif // !defined(AFX_SCRIPTRUNNER_H__07726496_4736_4704_A65C_EC16DFA8E0E5__INCLUDED_)
