/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: ScriptRunner.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// ScriptRunner.cpp: implementation of the CScriptRunner class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "bk.h"
#include "ScriptRunner.h"
#include "Defines.h"
#include "Globals.h"
#include "Board.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CScriptRunner::CScriptRunner()
{
	m_pChip = NULL;
	
	m_fileScript.m_hFile = NULL;

	m_nScriptLinePos = 0;
	m_scriptCurrTick = 0;
	m_scriptStartDelay = SCRIPT_START_DELAY;
	m_bRus = FALSE;
}

CScriptRunner::~CScriptRunner()
{
	SetScriptPath (_T(""));
}



/////////////////////////////////////////////////////////////////////////////
void CScriptRunner::SetScriptPath (CString strScriptPath)
{
	if (m_fileScript.m_pStream)
		m_fileScript.Close ();

	m_strScriptFileName = strScriptPath;
	m_strScriptLine = _T("");			
}



/////////////////////////////////////////////////////////////////////////////
BOOL CScriptRunner::RunScript ()
{
	ASSERT (m_pChip);
	if (!m_pChip) // If no Board return error
		return FALSE;

	if (m_strScriptFileName.IsEmpty ())
		return FALSE; // If no script specified return error

	if (!m_fileScript.m_pStream)
	{
		// If file does not open

		if (!m_fileScript.Open (m_strScriptFileName, CFile::modeRead))
		{
			// If can't opeen script file then reinitialize script engine
			// and quit with error
			m_strScriptFileName = _T("");
			return FALSE;
		}

		// If script open initialize script members
		m_strScriptLine = _T("");
		m_nScriptLinePos = 0;
		m_scriptCurrTick = GetTickCount (); // Start timer
	}

	// if script file opened and all ok
	// Wait for specified delay befor run script
	if ((GetTickCount () - (double)m_scriptCurrTick) / 1000 < m_scriptStartDelay)
		return TRUE;
	
	if (m_nScriptLinePos >= m_strScriptLine.GetLength ())
	{
		// If end of current line then
		// read next line from script 
		m_nScriptLinePos = 0;

		if (!m_fileScript.ReadString (m_strScriptLine))
		{
			// If there is no next line
			// close file and reinitialize script members
			SetScriptPath (_T(""));
			
			return FALSE;
		}

		m_strScriptLine += _T('\n'); // Add carrige return to the end of line
	}

	if (!m_strScriptLine.IsEmpty ())
	{
		// If not empty
		// Get current registers state
		WORD reg177660 = m_pChip->GetWordIndirect (0177660);
		WORD psw = m_pChip->GetPSW ();
		
		// Set new character only if bk 177660 register ready
		// another word wait berore BK readed next 177662 code
		if ((reg177660 & 0200) == 0 && (psw & PSW_P) == 0)
		{
			TCHAR ch = m_strScriptLine[m_nScriptLinePos++];
		
			ParseNextChar (ch);
		}
	}
	
	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
void CScriptRunner::ParseNextChar (TCHAR ch)
{
	BYTE ansi_ch = ch;

	if (ansi_ch == _T('|'))
	{
		m_scriptCurrTick = GetTickCount ();
		return;
	}
	else if (ansi_ch >= 192 && !m_bRus)
	{
		m_nScriptLinePos--;
		ansi_ch = BKKEY_RUS;
		m_bRus = TRUE;
	}
	else if (ch >= 32 && ch <= 127 && m_bRus)
	{
		m_nScriptLinePos--;
		ansi_ch = BKKEY_LAT;
		m_bRus = FALSE;
	}

	SendNewCharToBK (ansi_ch);
}



/////////////////////////////////////////////////////////////////////////////
void CScriptRunner::SendNewCharToBK (TCHAR ch)
{
	ANSIToBK (&ch); // Convert Line to BK Code page

	// Get current registers state
	WORD reg177660 = m_pChip->GetWordIndirect (0177660);

	// Set keyboard state bit in 177660
	m_pChip->SetWordIndirect (0177660, reg177660 | 0200);

	// Set key code in 177662
	m_pChip->SetWordIndirect (0177662, ch & 0177);

	// Set keypressed flag in 177716
	WORD reg177716 = m_pChip->GetWordIndirect (0177716);
	m_pChip->SetWordIndirect (0177716, reg177716 & ~0100);

	//if (!m_bIsAr2Press)
		m_pChip->KeyboardInterrupt (INTERRUPT_60);
	//else
	//	m_pChip->KeyboardInterrupt (INTERRUPT_274);
}
