/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: Screen.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// CScreen.h : interface of the CScreen class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_CSCREEN_H__B33BAB0A_8966_4DA6_ACEF_667FF68CD40C__INCLUDED_)
#define AFX_CSCREEN_H__B33BAB0A_8966_4DA6_ACEF_667FF68CD40C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <ddraw.h>

#include "Device.h"
#include "DST.h"
#include "Defines.h"
#include "DDrawWindow.h"

/////////////////////////////////////////////////////////////////////////////
// CScreen window

class CScreen : public CWnd, public CDevice 
{
	int					m_nFrame;
	int					m_curFPS;
	int					m_msec;

	BYTE*				m_colTable8;
	BYTE*				m_monTable8;
	WORD*				m_colTable16;
	WORD*				m_monTable16;
	DWORD*				m_colTable32;
	DWORD*				m_monTable32;

	BOOL				m_bFullScreen;
	BOOL				m_bSaveCurrentMode;

	CBitmap				m_bmScreen;
	BYTE*				m_pScreenBits;
	int					m_columnspp;
	int					m_linespp;
	int					m_bpp;
	
	BOOL				m_bColorMode;
	BOOL				m_bAdapt;

	BOOL				m_bExtended;
	BYTE				m_nOfs;
	
	CDDrawWindow		m_DDWnd;
	CComPtr<IDirectDraw7>		m_pDD;
	CComPtr<IDirectDrawSurface7>m_pPrimarySurface;
	CComPtr<IDirectDrawSurface7>m_pBackSurface;
	CComPtr<IDirectDrawPalette>	m_pPalette;

	BOOL				InitDirectDraw ();
	BOOL				CreateScreenBuffer ();
	void				CreatePalette ();
	void				ChangeDisplayMode ();
	
	void				SetScreenByte (WORD addr, BYTE val);
	void				SetScreenWord (WORD addr, WORD val);

// Construction
public:
	CScreen();

// Attributes
public:

// Operations
public:
	void				InitColorTables ();

	// Virtual method called after reset command
	virtual void		OnReset ();
	
	// Methods for Set/Get byte/word
	virtual void		GetByte (int addr, BYTE* pValue);
	virtual void		GetWord (int addr, WORD* pValue);
	virtual void		SetByte (int addr, BYTE value);
	virtual void		SetWord (int addr, WORD value);
		
	// Screen own methods
	void				SetOffset (BYTE nOfs);
	void				SetExtendedMode (BOOL bFlag);
	void				SetSaveCurrentMode (BOOL bFlag);
	BYTE				GetOffset ();
	BOOL				GetExtendedMode () {return m_bExtended;}
	BOOL				IsSaveCurrentMode () {return m_bSaveCurrentMode;}
	int					GetFPS () {return m_curFPS;}
	
	void				DrawScreen ();
	CRect				GetScreenRect ();

	void				SetAdaptMode (BOOL bFlag);
	BOOL				IsAdaptMode () {return m_bAdapt;}

	void				SetColorMode (BOOL bColorMode = TRUE);
	BOOL				IsColorMode (){return m_bColorMode;}

	BOOL				SetFullScreenMode ();
	BOOL				SetWindowMode ();
	BOOL				IsFullScreenMode () {return m_bFullScreen;}

	CWnd*				GetBackgroundWindow () {return &m_DDWnd;}
	HBITMAP				GetScreenshot ();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CScreen)
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CScreen();

	// Generated message map functions
protected:
	//{{AFX_MSG(CScreen)
	afx_msg void OnPaint();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CSCREEN_H__B33BAB0A_8966_4DA6_ACEF_667FF68CD40C__INCLUDED_)
