/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: PrintDlg.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




#if !defined(AFX_PRINTDLG_H__A45CDF40_009E_4992_B6A6_28A9B324C132__INCLUDED_)
#define AFX_PRINTDLG_H__A45CDF40_009E_4992_B6A6_28A9B324C132__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// PrintDlg.h : header file
//

class CDebugger;

/////////////////////////////////////////////////////////////////////////////
// CPrintDlg dialog

class CPrintDlg : public CPrintDialog
{
	DECLARE_DYNAMIC (CPrintDlg)

	void				CulcPages ();
	void				HideControls ();
	BOOL				GetStartAddress ();
	BOOL				GetEndAddress ();

public:
	CPrintDlg (BOOL bPrintSetupOnly,
		// TRUE for Print Setup, FALSE for Print Dialog
		DWORD dwFlags = PD_ALLPAGES | PD_USEDEVMODECOPIES | PD_NOPAGENUMS
			| PD_HIDEPRINTTOFILE | PD_NOSELECTION,
		CWnd* pParentWnd = NULL);

	CDebugger*			m_pDebugger;
	CString				m_strTitle;
	BOOL				m_bPrintScreen;
	BOOL				m_bInverse;
	WORD				m_startAddr;
	WORD				m_endAddr;
	int					m_nPages;

protected:
	//{{AFX_MSG(CPrintDlg)
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg	void OnPrintScreen ();
	afx_msg	void OnPrintCode ();
	afx_msg	void OnInverse ();
	afx_msg void OnOk ();
	afx_msg void OnStartAddr ();
	afx_msg void OnEndAddr ();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_PRINTDLG_H__A45CDF40_009E_4992_B6A6_28A9B324C132__INCLUDED_)
