/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: PrintDlg.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// PrintDlg.cpp : implementation file
//

#include "stdafx.h"
#include "bk.h"
#include "Globals.h"
#include "PrintDlg.h"
#include "Debugger.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPrintDlg

IMPLEMENT_DYNAMIC(CPrintDlg, CPrintDialog)

CPrintDlg::CPrintDlg (BOOL bPrintSetupOnly, DWORD dwFlags, CWnd* pParentWnd) :
	CPrintDialog (bPrintSetupOnly, dwFlags, pParentWnd)
{
	m_pd.lpPrintTemplateName = (LPTSTR)MAKEINTRESOURCE (IDD_PRINT); 
	//m_pd.lpSetupTemplateName = (LPTSTR)MAKEINTRESOURCE (IDD_PRINT);
	m_pd.Flags |= PD_ENABLEPRINTTEMPLATE; 
	//m_pd.Flags |= PD_ENABLESETUPTEMPLATE;
	m_pd.hInstance = AfxGetInstanceHandle (); 
	AfxGetApp ()->GetPrinterDeviceDefaults (&m_pd);

	m_pd.nCopies = 1;
}


BEGIN_MESSAGE_MAP(CPrintDlg, CPrintDialog)
	//{{AFX_MSG_MAP(CPrintDlg)
	ON_WM_SHOWWINDOW()
	ON_COMMAND (IDC_PRINT_SCREEN, OnPrintScreen)
	ON_COMMAND (IDC_PRINT_CODE, OnPrintCode)
	ON_COMMAND (IDC_INVERSE, OnInverse)
	ON_COMMAND (IDOK, OnOk)
	ON_EN_CHANGE (IDC_START_ADDR, OnStartAddr)
	ON_EN_CHANGE (IDC_END_ADDR, OnEndAddr)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////
void CPrintDlg::OnPrintScreen ()
{
	m_bPrintScreen = IsDlgButtonChecked (IDC_PRINT_SCREEN);
	
	HideControls ();
}



/////////////////////////////////////////////////////////////////////////////
void CPrintDlg::OnPrintCode ()
{
	m_bPrintScreen = IsDlgButtonChecked (IDC_PRINT_SCREEN);
	
	HideControls ();
}



/////////////////////////////////////////////////////////////////////////////
void CPrintDlg::OnInverse ()
{
	m_bInverse = IsDlgButtonChecked (IDC_INVERSE);
}



/////////////////////////////////////////////////////////////////////////////
void CPrintDlg::OnStartAddr ()
{
	GetStartAddress ();
}



/////////////////////////////////////////////////////////////////////////////
void CPrintDlg::OnEndAddr ()
{
	GetEndAddress ();
}



/////////////////////////////////////////////////////////////////////////////
void CPrintDlg::OnOk ()
{
	if (!GetStartAddress ())
		return;

	if (!GetEndAddress ())
		return;

	GetDlgItemText (IDC_TITLE, m_strTitle);
	
	CPrintDialog::OnOK ();
}



/////////////////////////////////////////////////////////////////////////////
void CPrintDlg::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CPrintDialog::OnShowWindow (bShow, nStatus);
	CBKDialog::ChangeCommonDialogFont (this);
	
	CString str;

	//CButton* pButton = (CButton*)GetDlgItem (IDC_PRINT_SCREEN);

	//if (pButton)
	{
		CheckDlgButton (IDC_PRINT_SCREEN, m_bPrintScreen);
		CheckDlgButton (IDC_INVERSE, m_bInverse);
		SetDlgItemText (IDC_START_ADDR, WordToOctString (m_startAddr));
		SetDlgItemText (IDC_END_ADDR, WordToOctString (m_endAddr));
		SetDlgItemText (IDC_TITLE, m_strTitle);
		
		HideControls ();
	}
}



/////////////////////////////////////////////////////////////////////////////
void CPrintDlg::HideControls ()
{
	CWnd* pWnd = GetDlgItem (IDC_INVERSE);

	if (pWnd)
	{
		pWnd->EnableWindow (m_bPrintScreen);
		pWnd = GetDlgItem (IDC_START_ADDR);
		pWnd->EnableWindow (!m_bPrintScreen);
		pWnd = GetDlgItem (IDC_END_ADDR);
		pWnd->EnableWindow (!m_bPrintScreen);
	}
}



/////////////////////////////////////////////////////////////////////////////
BOOL CPrintDlg::GetStartAddress ()
{
	CString strAddress;
	GetDlgItemText (IDC_START_ADDR, strAddress);
	
	m_startAddr = OctStringToWord (strAddress);
	
	CulcPages ();
	
	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
BOOL CPrintDlg::GetEndAddress ()
{
	CString straddress;
	GetDlgItemText (IDC_END_ADDR, straddress);
	
	m_endAddr = OctStringToWord (straddress);
	
	CulcPages ();
	
	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
void CPrintDlg::CulcPages ()
{
	ASSERT (m_pDebugger);

	WORD curAddr = m_startAddr;

	CString strInstr;
	CString strArg;
	WORD codes[3];

	int nPages = 1;
	int nLines = 0;

	while (curAddr < m_endAddr)
	{
		curAddr += m_pDebugger->DebugInstruction (curAddr, strInstr, strArg, codes) * 2;
		nLines ++;

		if (nLines == 60)
		{
			nPages++;
			nLines = 0;
		}
	}

	SetDlgItemInt (IDC_PAGES, nPages);

	m_nPages = nPages;
}