/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: PanelBackground.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// PanelBackground.cpp : implementation file
//

#include "stdafx.h"
#include "Panel.h"
#include "PanelBackground.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPanelBackground

CPanelBackground::CPanelBackground()
{
	m_bMouseTransparence = TRUE;
}

CPanelBackground::~CPanelBackground()
{
}


BEGIN_MESSAGE_MAP(CPanelBackground, CWnd)
	//{{AFX_MSG_MAP(CPanelBackground)
	ON_WM_PAINT()
	ON_WM_NCHITTEST()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPanelBackground message handlers


/////////////////////////////////////////////////////////////////////////////
void CPanelBackground::PutOnPanel (CPanel* pPanel)
{
	m_pPanel = pPanel;
}


void CPanelBackground::SetMouseTransparence (BOOL bTransparence)
{
	m_bMouseTransparence = bTransparence;
}



/////////////////////////////////////////////////////////////////////////////
void CPanelBackground::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

	CRect rcBound;
	GetClientRect (&rcBound);
	
	m_pPanel->OnDraw (&dc, rcBound);
	// Do not call CWnd::OnPaint() for painting messages
}



/////////////////////////////////////////////////////////////////////////////
UINT CPanelBackground::OnNcHitTest(CPoint point) 
{
	if (m_bMouseTransparence)
		return HTTRANSPARENT;
	else
		return CWnd::OnNcHitTest(point);
}
