/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: Panel.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// Panel.h: interface for the CPanel class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PANEL_H__4E819513_A515_4F98_8ACB_7BFD5BE0874E__INCLUDED_)
#define AFX_PANEL_H__4E819513_A515_4F98_8ACB_7BFD5BE0874E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <AfxTempl.h>
#include "PanelBackground.h"

//////////////////////////////////////////////////////////////////////
class CPanel;
class CPanelSplitter;

#ifndef fabs
#define fabs(a) ((a >= 0.0) ? (a) : (-a))
#endif

typedef CTypedPtrList <CPtrList, CPanel*> CPanelList;

enum	{WINDOW_HCENTERED = 0, WINDOW_RIGHT = 1, WINDOW_LEFT = 2, WINDOW_HSTRETCHED = 3,
			WINDOW_VCENTERED = 0, WINDOW_BOTTOM = 8, WINDOW_TOP = 16, WINDOW_VSTRETCHED = 24};

#define WINDOW_STRETCHED	(WINDOW_HSTRETCHED | WINDOW_VSTRETCHED)
#define WINDOW_CENTERED		(WINDOW_HCENTERED | WINDOW_VCENTERED)
	
//////////////////////////////////////////////////////////////////////
class CPanel  
{
public:
	// Child window alignment flags
	// Panel alignment flags
	enum			{ALIGN_NOWHERE = -1, ALIGN_RIGHT = 0, ALIGN_LEFT, ALIGN_BOTTOM, ALIGN_TOP};
	// default border size
	enum			{DEFAULT_BORDER_SIZE = 1};
	// default panel max size
	enum			{DEFAULT_MAX_SIZE = 100000};

protected:

	// Dialog control handler
	struct CTRLINFO
	{
		HWND				hCtrl; // id of control
		CRect				ctrlRect; // initial dialog template place of control
	};					

	// List of dialog controls
	typedef CList <CTRLINFO, CTRLINFO&>	CCtrlInfoList; 

	int					m_windowAlign;			// window or controls alignment relative panel
	BOOL				m_bFromDialog;			// flag show what is m_hWnd member wnd or dialog
	BOOL				m_bSizeRelativeToWindow;// flag specified relativity of coordinates
	BOOL				m_bHide;
	BOOL				m_bDrawDebugInfo;		// flag draw or not debug panel information
	BOOL				m_bEnableSplitter;		// flag for enable or disable splitter
	BOOL				m_bMouseTransparentBkg;	// mouse transparence for background window
	HWND				m_hBaseWnd;
	HWND				m_hWnd;					// child window or dialog
	CCtrlInfoList		m_ctrlsInfoList;		// list of handlers of teplate of dialog
	CRect				m_rcControlsBound;		// bouding frame of group of dialog contols
	CRect				m_rcBorder;				// specify left, top, right and bottom borders
	int					m_firstID;				// first dialog control id
	int					m_lastID;				// last dialog control id
	TCHAR				m_name[64];				// panel name

	int					m_align;				// panel alignment relative parent panel
	BOOL				m_bFixedWidth;
	BOOL				m_bFixedHeight;
	BOOL				m_bParentWidth;
	BOOL				m_bParentHeight;
	double				m_original_xpos;		// initial specified x position
	double				m_original_ypos;		// initial specified y position
	double				m_original_cx;			// initial specified width
	double				m_original_cy;			// initial specified height
	double				m_xpos;					// current x position
	double				m_ypos;					// current y position
	double				m_cx;					// current width
	double				m_cy;					// current height
	int					m_fixedWidth;			// initial specified fixed width in pixels
	int					m_fixedHeight;			// initial specified fixed height in pixels
	int					m_fixed_min_width;		// minimum panel width
	int					m_fixed_min_height;		// minimum panel height
	int					m_fixed_max_width;		// maximum panel width
	int					m_fixed_max_height;		// maximum panel height
	
	CPanel*				m_pParent;				// pointer to parent panel
	CPanelList			m_childList;			// list of pointer to child panels
	CPanelSplitter*		m_pSplitter;			// splitter panel
	CPanelBackground	m_backgroundWnd;		// background window
	COLORREF			m_clrBackground;		// background fill color
	COLORREF			m_clrSplitter;			// splitter color

protected:
	virtual void		OnSetAlign (int align);				// Called after panel has been attached
	virtual	void		OnSetParent ();						// Called after panel initializing
	virtual void		OnDraw (CDC* pDC, CRect& rcBound);	// Called then panel drawing
	virtual void		OnDrawSplitter (CDC* pDC, CRect& rcBound);	// Called then panel drawing it splitter
	virtual void		OnMeasureRect (CRect* pRect);		// Called then panel calculate it sizes
	virtual void		OnRecalcWindowsZorder ();			// Called for reposition panel windows by z-order
	virtual void		OnResizeWindows ();					// Layout call this then windows resizing
	virtual void		OnShow (BOOL bShow);				// Called on showing or hiding layout panels

	void				ApplyAlignment (int align, CPanel* pPanel);
	void				SetSizeRelativeToParentPanel ();
	void				SetAlign (int align);
	void				SetParent (CPanel* pParent);
	CPanel*				GetTopLevelParent ();
	BOOL				IsUnique (CPanel* pPanel);
	BOOL				IsUniqueName (CPanel* pPanel);
	void				NormalizePanel (double& m_xpos, double& m_ypos, double& m_cx, double& m_cy);
	CRect				GetInitialRect ();
	
	void				AddBorder (CRect* pRcPanel);
	void				SetWindowPos ();
	void				SetOneWindowPos ();
	void				SetDialogWindowsPos ();
	void				SetBackgroundPos ();
	void				CreateDialogCtrlsInfo ();
	void				ClearDialogCtrlsInfo ();
	void				CreateBackground ();
	void				AddSplitter ();
	
public:
	// All parameters may be set in two variants
	// 1. double	- relative panel coordinates
	// 2. int		- absolute panel coordinates
	// If parameter zero (0.0) assume that whis dimension equal corresponding parent dimension

	// Panel class factory
	// Make main panel with 0.0, 0.0 - 1.0, 1.0
	static CPanel*		CreatePanelInstance (CWnd* pBaseWnd);
	// Make panel with relative width and height
	static CPanel*		CreatePanelInstance (const TCHAR* pName, double size);
	// Make panel with absolute width and height
	static CPanel*		CreatePanelInstance (const TCHAR* pName, int size);

	// Panel Constructors
	// Make main panel with 0.0, 0.0 - 1.0, 1.0
	CPanel (CWnd* pBaseWnd);
	// Make panel with relative width or height
	CPanel (const TCHAR* pName, double size);
	// Make panel with absolute width or height
	CPanel (const TCHAR* pName, int size);
	virtual ~CPanel ();

	// Set/Get panel info
	void				SetName (const TCHAR* pName);
	void				SetBase (CWnd* pBaseWnd);
	const TCHAR*		GetName ();
	int					GetAlign () {return m_align;}
	CPanel*				GetParent() {return m_pParent;}
	CWnd*				GetBase ();

	// Calc panel rect in specified coordinates
	CRect				GetRect ();
	CRect				GetScreenRect ();
	
	//Add panel to different sides of parent panel
	void				Add (CPanel* pPanel, int align, BOOL bAtHead = FALSE);
	void				AddToRight (CPanel* pPanel, BOOL bAtHead = FALSE);
	void				AddToLeft (CPanel* pPanel, BOOL bAtHead = FALSE);
	void				AddToBottom (CPanel* pPanel, BOOL bAtHead = FALSE);
	void				AddToTop (CPanel* pPanel, BOOL bAtHead = FALSE);
	void				AddBefor (CPanel* pPanel);
	void				AddAfter (CPanel* pPanel);
	BOOL				CanInsertPanel (CPanel* pPanel);

	// Get specified name panel
	CPanel*				GetPanel (const TCHAR* pName);
	CPanel*				GetPanel (CPoint ptPos);
	
	// Set/Get one of dimension relative or fixed
	void				SetFixedWidth (int width);
	void				SetFixedHeight (int height);
	int					GetFixedWidth ();
	int					GetFixedHeight ();

	// Call this methods to realign panel tree befor draw
	void				ResizeToWindow ();

	// Call this method for recalc panel windows z-orders
	void				RecalcWindowsZorder ();
	
	// Call this methods to draw panel tree
	void				DrawToWindow (BOOL bInvalidateAll = FALSE);
	void				DrawDebugInfo (BOOL bEnabled);
	
	// Inser child window to panel whith specified alignment
	void				InsertWindow (CWnd* pWnd, int windowAlign);
	void				InsertWindow (CWnd* pWnd, int ctrlID, int windowAlign);
	void				InsertWindow (CWnd* pWnd, int firstID, int lastID, int windowAlign);

	// Call this methods to change or get border sizes
	void				SetBorder (int all);
	void				SetBorder (int hor, int ver);
	void				SetBorder (int left, int top, int right, int bottom);
	void				SetBorder (CRect& rcBorder);
	CRect				GetBorder () {return m_rcBorder;}

	// Call this methods t show/hide layout or redraw
	BOOL				IsShown () {return !m_bHide;}
	void				Show (BOOL bShow);
	void				Redraw (BOOL bInvalidateAll = FALSE);

	// Splitter functions
	void				EnableSplitter ();
	void				DisableSplitter ();
	
	// Call this methods for remove panels
	CPanel*				RemovePanel (CPanel* pPanel);
	CPanel*				RemovePanel (TCHAR* pName);

	// Set/Get layout colors
	void				SetBackgroundColor (COLORREF clr) {m_clrBackground = clr;}
	void				SetSplitterColor (COLORREF clr) {m_clrSplitter = clr;}
	COLORREF			GetBackgroundColor () {return m_clrBackground;}
	COLORREF			GetSplitterColor () {return m_clrSplitter;}

	friend				CPanelBackground;
	friend				CPanelSplitter;
};

#endif // !defined(AFX_PANEL_H__4E819513_A515_4F98_8ACB_7BFD5BE0874E__INCLUDED_)
