/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: MultiEditListCtrl.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




#if !defined(AFX_MULTIEDITLISTCTRL_H__91829073_368D_4B3F_ABCC_F325877E6AF8__INCLUDED_)
#define AFX_MULTIEDITLISTCTRL_H__91829073_368D_4B3F_ABCC_F325877E6AF8__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// MultiEditListCtrl.h : header file
//

#include "Globals.h"

/////////////////////////////////////////////////////////////////////////////
// CMultiEdit window

class CMultiEditListCtrl;

class CMultiEdit : public CEdit
{
	CMultiEditListCtrl*	m_pListCtrl;
	int					m_nItem;
	int					m_nSubItem;

	void				SetItem ();

// Construction
public:
	CMultiEdit();

// Attributes
public:

// Operations
public:
	void				Attach (CMultiEditListCtrl* pListCtrl, int nItem, int nSubItem);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMultiEdit)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMultiEdit();

	// Generated message map functions
protected:
	//{{AFX_MSG(CMultiEdit)
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////
// CMultiEditListCtrl window

class CMultiEditListCtrl : public CListCtrl
{
	enum				{MODIFIED_COLOR = RGB (255, 0, 0)};

	struct ITEM_INFO
	{
		BOOL				bEditable;
		COLORREF			clrText;
		COLORREF			clrTextBk;
	};
	
	CMultiEdit*			m_pEdit;
	CFont				m_font;
	CArray <ITEM_INFO*, ITEM_INFO*> m_colorTable;
	
	void				InitColorTable ();
	void				ClearColorTable ();
	int					GetColumnNumber ();
// Construction
public:
	CMultiEditListCtrl();

// Attributes
public:

// Operations
public:
	void				EnableEdit (BOOL bEnable, int nItem, int nColumn);
	void				EnableRowEdit (BOOL bEnable, int nRow);
	void				EnableColumnEdit (BOOL bEnable, int nColumn);
	void				SetItemColor (COLORREF col, int nItem, int nColumn);
	void				SetRowColor (COLORREF col, int nRow);
	void				SetColumnColor (COLORREF col, int nColumn);
	void				SetItemBkColor (COLORREF col, int nItem, int nColumn);
	void				SetRowBkColor (COLORREF col, int nRow);
	void				SetColumnBkColor (COLORREF col, int nColumn);
	void				SetItemWithModified (WORD word, int nItem, int nSubitem);
	void				SetItemWithModified (CString str, int nItem, int nSubitem);
	
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMultiEditListCtrl)
	protected:
	virtual void PreSubclassWindow();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMultiEditListCtrl();

	// Generated message map functions
protected:
	//{{AFX_MSG(CMultiEditListCtrl)
	afx_msg BOOL OnDblclk(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomDraw(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg BOOL OnInsertitem(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg BOOL OnDeleteitem(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg BOOL OnDeleteallitems(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MULTIEDITLISTCTRL_H__91829073_368D_4B3F_ABCC_F325877E6AF8__INCLUDED_)
