/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: MultiEditListCtrl.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// MultiEditListCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "bk.h"
#include "MultiEditListCtrl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMultiEdit

CMultiEdit::CMultiEdit()
{
	m_pListCtrl = NULL;
}

CMultiEdit::~CMultiEdit()
{
}


BEGIN_MESSAGE_MAP(CMultiEdit, CEdit)
	//{{AFX_MSG_MAP(CMultiEdit)
	ON_WM_KILLFOCUS()
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
void CMultiEdit::Attach (CMultiEditListCtrl* pListCtrl, int nItem, int nSubItem)
{
	m_pListCtrl = pListCtrl;
	m_nItem = nItem;
	m_nSubItem = nSubItem;
}



/////////////////////////////////////////////////////////////////////////////
void CMultiEdit::OnKillFocus(CWnd* pNewWnd) 
{
	CEdit::OnKillFocus(pNewWnd);
	
	SetItem ();

	delete this;
}



/////////////////////////////////////////////////////////////////////////////
void CMultiEdit::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (nChar == VK_RETURN)
	{
		SetItem ();

		delete this;
		return;
	}
	
	CEdit::OnKeyDown(nChar, nRepCnt, nFlags);
}



/////////////////////////////////////////////////////////////////////////////
void CMultiEdit::SetItem ()
{
	CString strText;
	GetWindowText (strText);

	NMLISTVIEW* pLVNotyfy = new NMLISTVIEW;
	memset (pLVNotyfy, 0, sizeof (NMLISTVIEW));
	pLVNotyfy->hdr.hwndFrom = *m_pListCtrl;
	pLVNotyfy->hdr.idFrom = m_pListCtrl->GetDlgCtrlID ();
	pLVNotyfy->hdr.code = LVN_ITEMCHANGING;
	pLVNotyfy->iItem = m_nItem;
	pLVNotyfy->iSubItem = m_nSubItem;

	CWnd* pParent = m_pListCtrl->GetParent ();
	ASSERT (pParent);

	BOOL bProtect = FALSE;
	
	if (pParent)
		bProtect = pParent->SendMessage (WM_NOTIFY, pLVNotyfy->hdr.idFrom, (LPARAM)pLVNotyfy);
	
	if (!bProtect)
	{
		pLVNotyfy->hdr.code = LVN_ITEMCHANGED;
		m_pListCtrl->SetItemWithModified (strText, m_nItem, m_nSubItem);
		
		if (pParent)
			pParent->SendMessage (WM_NOTIFY, pLVNotyfy->hdr.idFrom, (LPARAM)pLVNotyfy);
	}

	delete pLVNotyfy;
}


/////////////////////////////////////////////////////////////////////////////
// CMultiEditListCtrl

CMultiEditListCtrl::CMultiEditListCtrl()
{
	m_pEdit = NULL;
	
	//m_font.CreatePointFont (80, _T("MS Sans Serif"));
}

CMultiEditListCtrl::~CMultiEditListCtrl()
{
	ClearColorTable ();
}



/////////////////////////////////////////////////////////////////////////////
// CMultiEditListCtrl message handlers

BEGIN_MESSAGE_MAP(CMultiEditListCtrl, CListCtrl)
	//{{AFX_MSG_MAP(CMultiEditListCtrl)
	ON_NOTIFY_REFLECT_EX(NM_DBLCLK, OnDblclk)
	ON_NOTIFY_REFLECT(NM_CUSTOMDRAW, OnCustomDraw)
	ON_NOTIFY_REFLECT_EX(LVN_INSERTITEM, OnInsertitem)
	ON_NOTIFY_REFLECT_EX(LVN_DELETEITEM, OnDeleteitem)
	ON_NOTIFY_REFLECT_EX(LVN_DELETEALLITEMS, OnDeleteallitems)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
void CMultiEditListCtrl::PreSubclassWindow() 
{
	LOGFONT lfnt;
	GetFont ()->GetLogFont (&lfnt);
	m_font.CreateFontIndirect (&lfnt);

	
	CListCtrl::PreSubclassWindow();
}



/////////////////////////////////////////////////////////////////////////////
BOOL CMultiEditListCtrl::OnDblclk(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LVHITTESTINFO hti;

	// Get current click info (item, subitem, etc.)
	::GetCursorPos (&hti.pt);
	ScreenToClient (&hti.pt);

	SubItemHitTest (&hti);

	if (hti.flags & LVHT_ONITEMLABEL && !(GetStyle () & LVS_EDITLABELS))
	{
		if (m_colorTable[hti.iItem][hti.iSubItem].bEditable)
		{
			// If label click - create edit ctrl for item
			CRect rcSubItem;
			GetSubItemRect (hti.iItem, hti.iSubItem, LVIR_LABEL, rcSubItem);
			ClientToScreen (&rcSubItem);

			m_pEdit = new CMultiEdit;
			//m_pEdit->Create (WS_VISIBLE|WS_CHILD|WS_BORDER|ES_WANTRETURN|ES_MULTILINE, rcSubItem, this, 0);
			m_pEdit->CreateEx (0, "edit", NULL, WS_VISIBLE|WS_POPUP|WS_BORDER|ES_WANTRETURN|ES_MULTILINE, rcSubItem, this, 0);
			m_pEdit->SetFont (&m_font);
			m_pEdit->Attach (this, hti.iItem, hti.iSubItem);
			m_pEdit->SetWindowText (GetItemText (hti.iItem, hti.iSubItem));
			m_pEdit->SetFocus ();
		}
	}
	
	*pResult = 0;

	return FALSE;
}



/////////////////////////////////////////////////////////////////////////////
void CMultiEditListCtrl::OnCustomDraw(NMHDR* pNMHDR, LRESULT* pResult)
{
	NMLVCUSTOMDRAW* pCustomDraw = (NMLVCUSTOMDRAW*)pNMHDR;

	*pResult = 0;

	switch (pCustomDraw->nmcd.dwDrawStage)
	{
	case CDDS_PREPAINT:
		*pResult = CDRF_NOTIFYITEMDRAW;
		break;
	
	case CDDS_ITEMPREPAINT:
		*pResult = CDRF_NOTIFYSUBITEMDRAW;
		break;

	case CDDS_SUBITEM | CDDS_ITEMPREPAINT:
		pCustomDraw->clrText = m_colorTable[pCustomDraw->nmcd.dwItemSpec][pCustomDraw->iSubItem].clrText;    
		pCustomDraw->clrTextBk = m_colorTable[pCustomDraw->nmcd.dwItemSpec][pCustomDraw->iSubItem].clrTextBk;
        *pResult = CDRF_NEWFONT;
      
		break;
	}

	//return FALSE;
}



/////////////////////////////////////////////////////////////////////////////
BOOL CMultiEditListCtrl::OnInsertitem(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	
	//int nStart = m_colorTable.GetSize () + 1;
	m_colorTable.SetAtGrow (pNMListView->iItem, new ITEM_INFO [GetColumnNumber ()]);
	//int nEnd = m_colorTable.GetSize () - 1;

	//for (int i = nStart; i < nEnd; i++)
	//	m_colorTable[i] = NULL;
	
	for (int i = 0; i < GetColumnNumber (); i++)
	{
		m_colorTable[pNMListView->iItem][i].bEditable = TRUE;
		m_colorTable[pNMListView->iItem][i].clrText = ::GetSysColor (COLOR_BTNTEXT);
		m_colorTable[pNMListView->iItem][i].clrTextBk = ::GetSysColor (COLOR_WINDOW);
	}

	*pResult = 0;

	return FALSE;
}



/////////////////////////////////////////////////////////////////////////////
BOOL CMultiEditListCtrl::OnDeleteitem(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	int nItemCount = GetItemCount ();

	if (pNMListView->iItem < nItemCount)
	{
		if (pNMListView->iItem < m_colorTable.GetSize ())
		{
			delete []m_colorTable[pNMListView->iItem];
			m_colorTable[pNMListView->iItem] = NULL;
			m_colorTable.RemoveAt (pNMListView->iItem);
		}
	}
	
	*pResult = 0;

	return FALSE;
}



/////////////////////////////////////////////////////////////////////////////
BOOL CMultiEditListCtrl::OnDeleteallitems(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	for (int i = 0; i < m_colorTable.GetSize (); i++)
	{
		delete []m_colorTable[i];
		m_colorTable[i] = NULL;
	}
	
	m_colorTable.RemoveAll ();
	
	*pResult = 0;

	return FALSE;
}



/////////////////////////////////////////////////////////////////////////////
void CMultiEditListCtrl::InitColorTable ()
{
}



/////////////////////////////////////////////////////////////////////////////
void CMultiEditListCtrl::ClearColorTable ()
{
	for (int n = 0; n < m_colorTable.GetSize (); n++)
		delete []m_colorTable[n];

	m_colorTable.RemoveAll ();
}



/////////////////////////////////////////////////////////////////////////////
int CMultiEditListCtrl::GetColumnNumber ()
{
	return GetHeaderCtrl ()->GetItemCount ();
}



/////////////////////////////////////////////////////////////////////////////
void CMultiEditListCtrl::EnableEdit (BOOL bEnable, int nItem, int nColumn)
{
	int nItemCount = GetItemCount ();

	ASSERT (nItemCount - 1 >= nItem);
	if (nItemCount - 1 < nItem)
		return;

	int nColumnCount = GetHeaderCtrl ()->GetItemCount ();
	ASSERT (nColumnCount - 1 >= nColumn);
	if (nColumnCount - 1 < nColumn)
		return;

	m_colorTable[nItem][nColumn].bEditable = bEnable;
}



/////////////////////////////////////////////////////////////////////////////
void CMultiEditListCtrl::EnableRowEdit (BOOL bEnable, int nRow)
{
	int nColumnCount = GetHeaderCtrl ()->GetItemCount ();

	for (int n = 0; n < nColumnCount; n++)
		EnableEdit (bEnable, nRow, n);
}



/////////////////////////////////////////////////////////////////////////////
void CMultiEditListCtrl::EnableColumnEdit (BOOL bEnable, int nColumn)
{
	int nRowCount = GetItemCount ();

	for (int n = 0; n < nRowCount; n++)
		EnableEdit (bEnable, n, nColumn);
}



/////////////////////////////////////////////////////////////////////////////
void CMultiEditListCtrl::SetItemColor (COLORREF col, int nItem, int nColumn)
{
	int nItemCount = GetItemCount ();

	ASSERT (nItemCount - 1 >= nItem);
	if (nItemCount - 1 < nItem)
		return;

	int nColumnCount = GetHeaderCtrl ()->GetItemCount ();
	ASSERT (nColumnCount - 1 >= nColumn);
	if (nColumnCount - 1 < nColumn)
		return;

	m_colorTable[nItem][nColumn].clrText = col;
}



/////////////////////////////////////////////////////////////////////////////
void CMultiEditListCtrl::SetRowColor (COLORREF col, int nRow)
{
	int nColumnCount = GetHeaderCtrl ()->GetItemCount ();

	for (int n = 0; n < nColumnCount; n++)
		SetItemColor (col, nRow, n);
}



/////////////////////////////////////////////////////////////////////////////
void CMultiEditListCtrl::SetColumnColor (COLORREF col, int nColumn)
{
	int nRowCount = GetItemCount ();

	for (int n = 0; n < nRowCount; n++)
		SetItemColor (col, n, nColumn);
}



/////////////////////////////////////////////////////////////////////////////
void CMultiEditListCtrl::SetItemBkColor (COLORREF col, int nItem, int nColumn)
{
	int nItemCount = GetItemCount ();

	ASSERT (nItemCount - 1 >= nItem);
	if (nItemCount - 1 < nItem)
		return;

	int nColumnCount = GetHeaderCtrl ()->GetItemCount ();
	ASSERT (nColumnCount - 1 >= nColumn);
	if (nColumnCount - 1 < nColumn)
		return;

	m_colorTable[nItem][nColumn].clrTextBk = col;
}



/////////////////////////////////////////////////////////////////////////////
void CMultiEditListCtrl::SetRowBkColor (COLORREF col, int nRow)
{
	int nColumnCount = GetHeaderCtrl ()->GetItemCount ();

	for (int n = 0; n < nColumnCount; n++)
		SetItemBkColor (col, nRow, n);
}



/////////////////////////////////////////////////////////////////////////////
void CMultiEditListCtrl::SetColumnBkColor (COLORREF col, int nColumn)
{
	int nRowCount = GetItemCount ();

	for (int n = 0; n < nRowCount; n++)
		SetItemBkColor (col, n, nColumn);
}



/////////////////////////////////////////////////////////////////////////////
void CMultiEditListCtrl::SetItemWithModified (WORD word, int nItem, int nSubitem)
{
	SetItemWithModified (IntToString (word, 8), nItem, nSubitem);
}



/////////////////////////////////////////////////////////////////////////////
void CMultiEditListCtrl::SetItemWithModified (CString str, int nItem, int nSubitem)
{
	CString strOld = GetItemText (nItem, nSubitem);
	CString strNew = str;

	BOOL bModified = (strOld != strNew);

	if (bModified)
		SetItemColor (MODIFIED_COLOR, nItem, nSubitem);
	else
		SetItemColor (::GetSysColor (COLOR_BTNTEXT), nItem, nSubitem);

	SetItemText (nItem, nSubitem, strNew);	
}
