/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: MemoryDumpCtrl.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




#if !defined(AFX_MEMORYDUMPCTRL_H__65B25473_1B58_45D5_8946_BF02378334CE__INCLUDED_)
#define AFX_MEMORYDUMPCTRL_H__65B25473_1B58_45D5_8946_BF02378334CE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// MemoryDumpCtrl.h : header file
//

/////////////////////////////////////////////////////////////////////////////
#include "Panel.h"
#include "MultiEditListCtrl.h"
#include "BKDialog.h"

/////////////////////////////////////////////////////////////////////////////
// CMemoryDumpCtrl dialog

class CMemoryDumpCtrl : public CBKDialog
{
	enum				{R0_COLUMN = 0, R1_COLUMN, R2_COLUMN, R3_COLUMN, R4_COLUMN, R5_COLUMN
		, SP_COLUMN, PC_COLUMN, PSW_COLUMN};
	enum				{REG177660_COLUMN = 0, REG177662_COLUMN, REG177664_COLUMN, REG177706_COLUMN
		, REG177710_COLUMN, REG177712_COLUMN, REG177714_COLUMN, REG177716_COLUMN};
	enum				{IDS_MEMORY_ADDR = 0, IDS_MEMORY_COLUMN1, IDS_MEMORY_COLUMN2, IDS_MEMORY_COLUMN3, IDS_MEMORY_COLUMN4
		, IDS_MEMORY_ASCII1, IDS_MEMORY_ASCII2, IDS_MEMORY_ASCII3, IDS_MEMORY_ASCII4};
	enum				{MAX_DUMP_COLS = 4};
	enum				{MAX_DUMP_ROWS = 64};
	enum				{COLUMN_WIDTH = 60};
	
	WORD				m_cur_dump_addr;
	CPanel*				m_pLayout;
	
	void				InitLayout ();
	void				SetCPURegister (WORD word, int nItem, int nSubitem);
	void				SetSystemRegister (WORD word, int nItem, int nSubitem);
	void				SetMemoryDump (WORD word, int nItem, int nSubitem);
	void				SetMemoryDumpAsANSI (WORD word, int nItem, int nSubitem);
	CString				FormatPSW (WORD value);

// Construction
public:
	CMemoryDumpCtrl(CWnd* pParent = NULL);   // standard constructor
	~CMemoryDumpCtrl();

	void				SetPSW (WORD value);
	void				SetAddress (int addr, WORD value);
	void				SetDump (WORD addr, WORD* pBuff);
	WORD				GetPSW ();
	WORD				GetDumpAddress () {return m_cur_dump_addr;}
	int					GetDumpColsCount () {return MAX_DUMP_COLS;}
	int					GetDumpRowsCount () {return MAX_DUMP_ROWS;}

private:
// Dialog Data
	//{{AFX_DATA(CMemoryDumpCtrl)
	enum { IDD = IDD_MEMORY_DUMP };
	CMultiEditListCtrl	m_listCPU;
	CMultiEditListCtrl	m_listSys;
	CMultiEditListCtrl	m_listMemory;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMemoryDumpCtrl)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CMemoryDumpCtrl)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	virtual void OnOK ();
	virtual void OnCancel ();
	afx_msg void OnItemchangedMdCpuRegisters(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnItemchangedMdSysRegisters(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnItemchangedMdMemory(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MEMORYDUMPCTRL_H__65B25473_1B58_45D5_8946_BF02378334CE__INCLUDED_)
