/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: MemoryDumpCtrl.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// MemoryDumpCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "bk.h"
#include "MemoryDumpCtrl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMemoryDumpCtrl dialog


CMemoryDumpCtrl::CMemoryDumpCtrl(CWnd* pParent /*=NULL*/)
	: CBKDialog(CMemoryDumpCtrl::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMemoryDumpCtrl)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_pLayout = NULL;
}

CMemoryDumpCtrl::~CMemoryDumpCtrl ()
{
	delete m_pLayout;
}

void CMemoryDumpCtrl::DoDataExchange(CDataExchange* pDX)
{
	CBKDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMemoryDumpCtrl)
	DDX_Control(pDX, IDC_MD_CPU_REGISTERS, m_listCPU);
	DDX_Control(pDX, IDC_MD_SYS_REGISTERS, m_listSys);
	DDX_Control(pDX, IDC_MD_MEMORY, m_listMemory);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMemoryDumpCtrl, CBKDialog)
	//{{AFX_MSG_MAP(CMemoryDumpCtrl)
	ON_WM_PAINT()
	ON_WM_SIZE()
	ON_WM_ERASEBKGND()
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_MD_CPU_REGISTERS, OnItemchangedMdCpuRegisters)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_MD_SYS_REGISTERS, OnItemchangedMdSysRegisters)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_MD_MEMORY, OnItemchangedMdMemory)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMemoryDumpCtrl message handlers

BOOL CMemoryDumpCtrl::OnInitDialog() 
{
	CBKDialog::OnInitDialog();

	// Create CPU registers list
	CString strHeader;

	strHeader.LoadString (IDS_MEMORY_R0);
	m_listCPU.InsertColumn (R0_COLUMN, strHeader, LVCFMT_LEFT, COLUMN_WIDTH);
	strHeader.LoadString (IDS_MEMORY_R1);
	m_listCPU.InsertColumn (R1_COLUMN, strHeader, LVCFMT_LEFT, COLUMN_WIDTH);
	strHeader.LoadString (IDS_MEMORY_R2);
	m_listCPU.InsertColumn (R2_COLUMN, strHeader, LVCFMT_LEFT, COLUMN_WIDTH);
	strHeader.LoadString (IDS_MEMORY_R3);
	m_listCPU.InsertColumn (R3_COLUMN, strHeader, LVCFMT_LEFT, COLUMN_WIDTH);
	strHeader.LoadString (IDS_MEMORY_R4);
	m_listCPU.InsertColumn (R4_COLUMN, strHeader, LVCFMT_LEFT, COLUMN_WIDTH);
	strHeader.LoadString (IDS_MEMORY_R5);
	m_listCPU.InsertColumn (R5_COLUMN, strHeader, LVCFMT_LEFT, COLUMN_WIDTH);
	strHeader.LoadString (IDS_MEMORY_SP);
	m_listCPU.InsertColumn (SP_COLUMN, strHeader, LVCFMT_LEFT, COLUMN_WIDTH);
	strHeader.LoadString (IDS_MEMORY_PC);
	m_listCPU.InsertColumn (PC_COLUMN, strHeader, LVCFMT_LEFT, COLUMN_WIDTH);
	strHeader.LoadString (IDS_MEMORY_PSW);
	m_listCPU.InsertColumn (PSW_COLUMN, strHeader, LVCFMT_LEFT, COLUMN_WIDTH);

	m_listCPU.InsertItem (0, _T(""));
	m_listCPU.SetItem (0, IDS_MEMORY_R1, LVIF_TEXT, _T(""), 0, 0, 0, 0);
	m_listCPU.SetItem (0, IDS_MEMORY_R2, LVIF_TEXT, _T(""), 0, 0, 0, 0);
	m_listCPU.SetItem (0, IDS_MEMORY_R3, LVIF_TEXT, _T(""), 0, 0, 0, 0);
	m_listCPU.SetItem (0, IDS_MEMORY_R4, LVIF_TEXT, _T(""), 0, 0, 0, 0);
	m_listCPU.SetItem (0, IDS_MEMORY_R5, LVIF_TEXT, _T(""), 0, 0, 0, 0);
	m_listCPU.SetItem (0, IDS_MEMORY_SP, LVIF_TEXT, _T(""), 0, 0, 0, 0);
	m_listCPU.SetItem (0, IDS_MEMORY_PC, LVIF_TEXT, _T(""), 0, 0, 0, 0);
	m_listCPU.SetItem (0, IDS_MEMORY_PSW, LVIF_TEXT, _T(""), 0, 0, 0, 0);
	m_listCPU.SetExtendedStyle (LVS_EX_FULLROWSELECT);
	
	// Create System registers list
	strHeader.LoadString (IDS_MEMORY_177660);
	m_listSys.InsertColumn (REG177660_COLUMN, strHeader, LVCFMT_LEFT, COLUMN_WIDTH);
	strHeader.LoadString (IDS_MEMORY_177662);
	m_listSys.InsertColumn (REG177662_COLUMN, strHeader, LVCFMT_LEFT, COLUMN_WIDTH);
	strHeader.LoadString (IDS_MEMORY_177664);
	m_listSys.InsertColumn (REG177664_COLUMN, strHeader, LVCFMT_LEFT, COLUMN_WIDTH);
	strHeader.LoadString (IDS_MEMORY_177706);
	m_listSys.InsertColumn (REG177706_COLUMN, strHeader, LVCFMT_LEFT, COLUMN_WIDTH);
	strHeader.LoadString (IDS_MEMORY_177710);
	m_listSys.InsertColumn (REG177710_COLUMN, strHeader, LVCFMT_LEFT, COLUMN_WIDTH);
	strHeader.LoadString (IDS_MEMORY_177712);
	m_listSys.InsertColumn (REG177712_COLUMN, strHeader, LVCFMT_LEFT, COLUMN_WIDTH);
	strHeader.LoadString (IDS_MEMORY_177714);
	m_listSys.InsertColumn (REG177714_COLUMN, strHeader, LVCFMT_LEFT, COLUMN_WIDTH);
	strHeader.LoadString (IDS_MEMORY_177716);
	m_listSys.InsertColumn (REG177716_COLUMN, strHeader, LVCFMT_LEFT, COLUMN_WIDTH);

	m_listSys.InsertItem (0, _T(""));
	m_listSys.SetItem (0, IDS_MEMORY_177662, LVIF_TEXT, _T(""), 0, 0, 0, 0);
	m_listSys.SetItem (0, IDS_MEMORY_177664, LVIF_TEXT, _T(""), 0, 0, 0, 0);
	m_listSys.SetItem (0, IDS_MEMORY_177706, LVIF_TEXT, _T(""), 0, 0, 0, 0);
	m_listSys.SetItem (0, IDS_MEMORY_177710, LVIF_TEXT, _T(""), 0, 0, 0, 0);
	m_listSys.SetItem (0, IDS_MEMORY_177712, LVIF_TEXT, _T(""), 0, 0, 0, 0);
	m_listSys.SetItem (0, IDS_MEMORY_177714, LVIF_TEXT, _T(""), 0, 0, 0, 0);
	m_listSys.SetItem (0, IDS_MEMORY_177716, LVIF_TEXT, _T(""), 0, 0, 0, 0);
	m_listSys.SetExtendedStyle (LVS_EX_FULLROWSELECT);

	// Create Memory dump list
	m_listMemory.InsertColumn (0, "", LVCFMT_LEFT, COLUMN_WIDTH);

	for (int i = 0; i < MAX_DUMP_COLS; i++)
	{
		m_listMemory.InsertColumn (i + 1, "", LVCFMT_LEFT, COLUMN_WIDTH);
		m_listMemory.InsertColumn (MAX_DUMP_COLS + 1, "", LVCFMT_LEFT, COLUMN_WIDTH);
	}

	for (i = 0; i < MAX_DUMP_ROWS; i++)
	{
		m_listMemory.InsertItem (i, _T(""));

		for (int n = 0; n < MAX_DUMP_COLS; n++)
		{
			m_listMemory.SetItem (i, n + 1, LVIF_TEXT, _T(""), 0, 0, 0, 0);
			m_listMemory.SetItem (i, n + MAX_DUMP_COLS + 1, LVIF_TEXT, _T(""), 0, 0, 0, 0);
			m_listMemory.EnableColumnEdit (FALSE, n + MAX_DUMP_COLS + 1);
		}
	}
	
	m_listMemory.SetColumnBkColor (::GetSysColor (COLOR_BTNFACE), 0);
	m_listMemory.EnableColumnEdit (FALSE, 0);
	m_listMemory.SetExtendedStyle (LVS_EX_FULLROWSELECT);

	WORD pBuff[100];
	SetDump (01000, pBuff);
	
	InitLayout ();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}



/////////////////////////////////////////////////////////////////////////////
void CMemoryDumpCtrl::InitLayout ()
{
	// Create layout
	delete m_pLayout;
	m_pLayout = new CPanel (this);

	// Add fixed controls to layout
	CPanel* pFixedCtrl = new CPanel (_T("Fixed"), 200);
	pFixedCtrl->InsertWindow (this, IDC_STATIC0, IDC_STATIC2, WINDOW_HSTRETCHED|WINDOW_TOP);
	pFixedCtrl->DrawDebugInfo (FALSE);
	m_pLayout->AddToTop (pFixedCtrl);

	// Add dinamic controls
	m_pLayout->InsertWindow (this, IDC_MD_MEMORY, WINDOW_STRETCHED); 

	m_pLayout->DrawDebugInfo (FALSE);
}



/////////////////////////////////////////////////////////////////////////////
void CMemoryDumpCtrl::OnOK ()
{
}



/////////////////////////////////////////////////////////////////////////////
void CMemoryDumpCtrl::OnCancel ()
{
}



/////////////////////////////////////////////////////////////////////////////
void CMemoryDumpCtrl::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// Draw layout with child windows
	if (m_pLayout)
		m_pLayout->DrawToWindow ();
	
	// Do not call CBKDialog::OnPaint() for painting messages
}



/////////////////////////////////////////////////////////////////////////////
void CMemoryDumpCtrl::OnSize(UINT nType, int cx, int cy) 
{
	CBKDialog::OnSize(nType, cx, cy);
	
	// Resize layout to current window size
	if (m_pLayout)
	{
		m_pLayout->ResizeToWindow ();
		m_pLayout->RecalcWindowsZorder ();
	}
}



/////////////////////////////////////////////////////////////////////////////
BOOL CMemoryDumpCtrl::OnEraseBkgnd(CDC* pDC) 
{
	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
void CMemoryDumpCtrl::SetCPURegister (WORD word, int nItem, int nSubitem)
{
	m_listCPU.SetItemWithModified (word, nItem, nSubitem);
}



/////////////////////////////////////////////////////////////////////////////
void CMemoryDumpCtrl::SetSystemRegister (WORD word, int nItem, int nSubitem)
{
	m_listSys.SetItemWithModified (word, nItem, nSubitem);
}



void CMemoryDumpCtrl::SetMemoryDump (WORD word, int nItem, int nSubitem)
{
	m_listMemory.SetItemWithModified (word, nItem, nSubitem);
}



/////////////////////////////////////////////////////////////////////////////
void CMemoryDumpCtrl::SetPSW (WORD value)
{
	m_listCPU.SetItemWithModified (FormatPSW (value), 0, PSW_COLUMN);
}



/////////////////////////////////////////////////////////////////////////////
WORD CMemoryDumpCtrl::GetPSW ()
{
	CString strPSW = m_listCPU.GetItemText (0, PSW_COLUMN);
	strPSW.MakeUpper ();
	int strLength = strPSW.GetLength ();
	
	WORD psw = 0;
	for (int n = 0; n < strLength; n++)
	{
		TCHAR ch = strPSW[n];

		switch (ch)
		{
		case _T('C'): psw |= PSW_C; break;
		case _T('V'): psw |= PSW_V; break;
		case _T('Z'): psw |= PSW_Z; break;
		case _T('N'): psw |= PSW_N; break;
		case _T('P'): psw |= PSW_P; break;
		case _T('T'): psw |= PSW_T; break;
		default: ASSERT (FALSE); break;
		}
	}

	return psw;
}



/////////////////////////////////////////////////////////////////////////////
void CMemoryDumpCtrl::SetAddress (int addr, WORD value)
{
	ASSERT (!(addr & 1));
	addr &= ~1;

	if (addr >= R0 && addr <= PC)
	{
		int nColumn = -1;
		switch (addr)
		{
		case R0: nColumn = R0_COLUMN; break;
		case R1: nColumn = R1_COLUMN; break;
		case R2: nColumn = R2_COLUMN; break;
		case R3: nColumn = R3_COLUMN; break;
		case R4: nColumn = R4_COLUMN; break;
		case R5: nColumn = R5_COLUMN; break;
		case SP: nColumn = SP_COLUMN; break;
		case PC: nColumn = PC_COLUMN; break;
		default: ASSERT (FALSE); break;
		}

		SetCPURegister (value, 0, nColumn);
	}
	else if (addr >= 0177660 && addr <= 0177716)
	{
		int nColumn = -1;
		switch (addr)
		{
		case 0177660: nColumn = REG177660_COLUMN; break;
		case 0177662: nColumn = REG177662_COLUMN; break;
		case 0177664: nColumn = REG177664_COLUMN; break;
		case 0177706: nColumn = REG177706_COLUMN; break;
		case 0177710: nColumn = REG177710_COLUMN; break;
		case 0177712: nColumn = REG177712_COLUMN; break;
		case 0177714: nColumn = REG177714_COLUMN; break;
		case 0177716: nColumn = REG177716_COLUMN; break;
		default: ASSERT (FALSE); break;
		}
		
		SetSystemRegister (value, 0, nColumn);
	}
	else
	{
		ASSERT (FALSE);
	}
}



/////////////////////////////////////////////////////////////////////////////
void CMemoryDumpCtrl::SetDump (WORD addr, WORD* pBuff)
{
	ASSERT (!(addr & 1));
	addr &= ~1;

	ASSERT (pBuff);

	m_cur_dump_addr = addr;
	int dump_addr = m_cur_dump_addr;
	int index = 0;

	for (int n = 0; n < MAX_DUMP_ROWS; n++)
	{
		SetMemoryDump (dump_addr, n, 0);

		for (int i = 0; i < MAX_DUMP_COLS; i++)
		{
			SetMemoryDump (pBuff[index], n, i + 1);
			SetMemoryDumpAsANSI (pBuff[index], n, i + MAX_DUMP_COLS + 1);
			index++;
		}

		dump_addr += MAX_DUMP_COLS * sizeof (WORD);

		if (dump_addr >= 65536)
			dump_addr -= 65536;
	}
}



/////////////////////////////////////////////////////////////////////////////
void CMemoryDumpCtrl::SetMemoryDumpAsANSI (WORD word, int nItem, int nSubitem)
{
	CString a ((BYTE)(word & 255));
	CString b ((BYTE)(word >> 8));

	if (a.GetAt (0) < ' ')
		a = "...";

	if (b.GetAt (0) < ' ')
		b = "...";

	CString str = a + " " + b;
	BKToANSI (str);

	m_listMemory.SetItemWithModified (str, nItem, nSubitem);
}



/////////////////////////////////////////////////////////////////////////////
void CMemoryDumpCtrl::OnItemchangedMdCpuRegisters(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	int addr = -1;

	switch (pNMListView->iSubItem)
	{
	case R0_COLUMN: addr = R0; break;
	case R1_COLUMN: addr = R1; break;
	case R2_COLUMN: addr = R2; break;
	case R3_COLUMN: addr = R3; break;
	case R4_COLUMN: addr = R4; break;
	case R5_COLUMN: addr = R5; break;
	case SP_COLUMN: addr = SP; break;
	case PC_COLUMN: addr = PC; break;
	case PSW_COLUMN: addr = PSW; break;
	default:
		ASSERT (FALSE); break;
	}

	WORD value = 0;
	
	if (addr == PSW)
		value = GetPSW ();
	else
		value = OctStringToWord (m_listCPU.GetItemText (pNMListView->iItem, pNMListView->iSubItem));

	CWnd* pParent = GetParent ();
	ASSERT (pParent);

	if (pParent)
		pParent->SendMessage (WM_DEBUG_MODIFY, value, addr);
	
	*pResult = 0;
}




/////////////////////////////////////////////////////////////////////////////
void CMemoryDumpCtrl::OnItemchangedMdSysRegisters(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	
	int addr = -1;
	
	switch (pNMListView->iSubItem)
	{
	case REG177660_COLUMN: addr = 0177660; break;
	case REG177662_COLUMN: addr = 0177662; break;
	case REG177664_COLUMN: addr = 0177664; break;
	case REG177706_COLUMN: addr = 0177706; break;
	case REG177710_COLUMN: addr = 0177710; break;
	case REG177712_COLUMN: addr = 0177712; break;
	case REG177714_COLUMN: addr = 0177714; break;
	case REG177716_COLUMN: addr = 0177716; break;
	default:
		ASSERT (FALSE); break;
	}

	WORD value = OctStringToWord (m_listCPU.GetItemText (pNMListView->iItem, pNMListView->iSubItem));

	CWnd* pParent = GetParent ();
	ASSERT (pParent);

	if (pParent)
		pParent->SendMessage (WM_DEBUG_MODIFY, value, addr);
	
	*pResult = 0;
}




/////////////////////////////////////////////////////////////////////////////
void CMemoryDumpCtrl::OnItemchangedMdMemory(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	if (pNMListView->iSubItem >= 1 && pNMListView->iSubItem <= MAX_DUMP_COLS)
	{
		int addr = m_cur_dump_addr + pNMListView->iItem * MAX_DUMP_COLS * sizeof (WORD);
		addr += (pNMListView->iSubItem - 1) * sizeof (WORD);
		
		WORD value = OctStringToWord (m_listCPU.GetItemText (pNMListView->iItem, pNMListView->iSubItem));

		CWnd* pParent = GetParent ();
		ASSERT (pParent);

		if (pParent)
			pParent->SendMessage (WM_DEBUG_MODIFY, value, addr);
	}
	
	*pResult = 0;
}



/////////////////////////////////////////////////////////////////////////////
CString	CMemoryDumpCtrl::FormatPSW (WORD value)
{
	CString strPSW;

	if (value & PSW_C)
		strPSW += 'C';
	
	if (value & PSW_V)
		strPSW += 'V';
	
	if (value & PSW_Z)
		strPSW += 'Z';
	
	if (value & PSW_N)
		strPSW += 'N';
	
	if (value & PSW_T)
		strPSW += 'T';
	
	if (value & PSW_P)
		strPSW += 'P';
	
	return strPSW;
}