/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: MainFrm.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// MainFrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAINFRM_H__319682E3_05D4_477F_BC31_E4F752371A35__INCLUDED_)
#define AFX_MAINFRM_H__319682E3_05D4_477F_BC31_E4F752371A35__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
class CMotherBoard;
class CBkSound;
class CPrintDlg;

/////////////////////////////////////////////////////////////////////////////
#include <AfxMt.h>

#include "DropTarget.h"
#include "Screen.h"
#include "Speaker.h"
#include "Covox.h"
#include "Tape.h"
#include "FDDController.h"
#include "Panel.h"
#include "Floater.h"
#include "MSF.h"
#include "DebugCtrl.h"
#include "MemoryDumpCtrl.h"
#include "TapeControlDlg.h"
#include "Debugger.h"
#include "ScriptRunner.h"


/////////////////////////////////////////////////////////////////////////////
class CMainFrame : public CFrameWnd
{
protected:
	enum				{TOOLBAR_HEIGHT = 25};
	enum				{STATUSBAR_HEIGHT = 18};
	enum				{PRINT_LINES_PER_PAGE = 66};
	enum				{PRINT_TAB_LENGTH = 8};

	CMutex				m_mtInstance;

	BOOL				m_bMenuLoop;
	CScreen				m_screen;
	CDebugCtrl			m_debugCtrl;
	CMemoryDumpCtrl		m_memoryCtrl;
	CTapeControlDlg		m_tapeCtrl;		
	
	// Layout
	CBKMenu				m_mainMenu;
	CPanel*				m_pLayout;
	CFloater			m_toolBarFloater;
	CFloater			m_debugWndFloater;
	CFloater			m_memoryWndFloater;
	BOOL				m_bFloatersInitialized;
	
	// Emulator
	CMotherBoard*		m_pChip;
	CDebugger			m_debugger;
	CBkSound*			m_pSound;
	CSpeaker			m_speaker;
	CCovox				m_covox;
	CTape				m_tape;
	CFDDController		m_fdd;
	BYTE*				m_pSampleBuffer;
	CScriptRunner		m_script;
	CDropTarget			m_dropTarget;
	
	BOOL				m_bPauseCPUAfterStart;
	WORD				m_CPURunAddr;
	DWORD				m_cpu_ips;
	DWORD				m_cpu_sps;
	float				m_initialCPUSpeed;
	BOOL				m_bIsAr2Press;
	BOOL				m_bIsShiftPress;
	BOOL				m_bIsKeyPress;
	BOOL				m_bBKKeyboard;
	BOOL				m_bJoystick;
	BOOL				m_bSavesDefault;
	BOOL				m_bShowPerfomance;
	BOOL				m_bEnableSaveCurrentMode;
	BOOL				m_bEmulateLoadTape;
	BOOL				m_bEmulateSaveTape;
	BOOL				m_bTapeAutoBeginDetection;
	BOOL				m_bTapeAutoEnsDetection;
	BOOL				m_bAskForBreak;
	BOOL				m_bShowDumpWindow;
	BOOL				m_bShowDebugWindow;

	CString				m_strBinPath;
	CString				m_strToolsPath;
	CString				m_strSavesPath;
	CString				m_strMemPath;
	CString				m_strTapePath;
	CString				m_strScriptsPath;
	CString				m_strIniFilePath;
	CString				m_strBinFileName;
	CString				m_strMemFileName;
	CString				m_strTapeFileName;
	CString				m_strScriptFileName;

	BOOL				m_bPrintScreen;
	BOOL				m_bPrintInverse;
	CString				m_strPrintTitle;

	// Functions for initialze emulator
	void				InitLayout ();
	void				InitFloaters ();
	void				InitMenu ();
	void				InitEmulator ();
	void				InitRegistry ();
	void				RegisterDefaultIcon (CString strExt, CString strSection, CString strDescription, DWORD iconID);
	void				RegisterShellCommand (CString strSection, CString strArguments);
	BOOL				ParseCommandLineParameters (CString strCommands);
	void				UpdateControls ();

	int					GetToolBarHeight ();

	BOOL				ConfigurationConstructor (int configuration);
	WORD				TranslateKey (int key, BOOL bShift, BOOL bExtended);
	void				EmulateTapeOperation ();
	BOOL				EmulateJoystickDown (UINT nChar, UINT nRepCnt, UINT nFlags);
	BOOL				EmulateJoystickUp (UINT nChar, UINT nRepCnt, UINT nFlags);
	BOOL				LoadMemoryState (CString strPath);
	BOOL				SaveMemoryState (CString strPath);
	void				SetDebugCtrlsState ();
	void				SetDebugCtrlsState (WORD debugAddress, WORD dumpAddress);
	void				SetFocusToBK ();
	void				SetFocusToDebug ();
	HBITMAP				GetScreenshot ();
	void				Print (CPrintDlg* pPrintDlg, WORD startAddress, WORD endAddress);
	WORD				PrintPage (CDC* pDC, CPrintInfo* pInfo, WORD currAddress, WORD endAddress);
	void				StartPlayTape (CString strPath);
	void				ClearProcessingFiles ();
	void				ProcessFile ();
	
public:
	CMainFrame();

protected: 
	DECLARE_DYNAMIC(CMainFrame)

// Attributes
public:

// Operations
public:
	HRESULT				OnMainLoop (WPARAM wParam, LPARAM lParam);
	void				OnDropFile (CString strPath);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainFrame)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMainFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  // control bar embedded members
	CStatusBar			m_wndStatusBar;
	CToolBar			m_wndToolBar;
	
// Generated message map functions
protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized);
	afx_msg void OnUpdateViewToolbar(CCmdUI* pCmdUI);
	afx_msg void OnViewToolbar();
	afx_msg void OnUpdateViewStatusBar(CCmdUI* pCmdUI);
	afx_msg void OnViewStatusBar();
	afx_msg HRESULT OnEnterMenuLoop (WPARAM wParam, LPARAM lParam);
	afx_msg HRESULT OnExitMenuLoop (WPARAM wParam, LPARAM lParam);
	afx_msg HRESULT OnEnterSizeMove (WPARAM wParam, LPARAM lParam);
	afx_msg HRESULT OnExitSizeMove (WPARAM wParam, LPARAM lParam);
	afx_msg HRESULT OnDisplayChange (WPARAM wParam, LPARAM lParam);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg HRESULT OnEmulateTape (WPARAM wParam, LPARAM lParam);
	afx_msg HRESULT OnCpuBreak (WPARAM wParam, LPARAM lParam);
	afx_msg HRESULT OnDebugModify (WPARAM wParam, LPARAM lParam);
	afx_msg void OnCpuRuncpu();
	afx_msg void OnViewFullscreenmode();
	afx_msg void OnUpdateViewColormode(CCmdUI* pCmdUI);
	afx_msg void OnViewColormode();
	afx_msg void OnUpdateViewAdaptivebwmode(CCmdUI* pCmdUI);
	afx_msg void OnViewAdaptivebwmode();
	afx_msg void OnUpdateOptionsEnableSpeaker(CCmdUI* pCmdUI);
	afx_msg void OnOptionsEnableSpeaker();
	afx_msg void OnUpdateOptionsEnableCovox(CCmdUI* pCmdUI);
	afx_msg void OnOptionsEnableCovox();
	afx_msg void OnUpdateCpuAccelerate(CCmdUI* pCmdUI);
	afx_msg void OnCpuAccelerate();
	afx_msg void OnUpdateCpuSlowdown(CCmdUI* pCmdUI);
	afx_msg void OnCpuSlowdown();
	afx_msg void OnUpdateCpuRunbk001001(CCmdUI* pCmdUI);
	afx_msg void OnCpuRunbk001001();
	afx_msg void OnUpdateCpuRunbk001001Focal(CCmdUI* pCmdUI);
	afx_msg void OnCpuRunbk001001Focal();
	afx_msg void OnUpdateCpuRunbk00100132k(CCmdUI* pCmdUI);
	afx_msg void OnCpuRunbk00100132k();
	afx_msg void OnUpdateOptionsEmulateBkkeyboard(CCmdUI* pCmdUI);
	afx_msg void OnOptionsEmulateBkkeyboard();
	afx_msg void OnUpdateOptionsEnableJoystick(CCmdUI* pCmdUI);
	afx_msg void OnOptionsEnableJoystick();
	afx_msg void OnUpdateOptionsUseSavesdirectory(CCmdUI* pCmdUI);
	afx_msg void OnOptionsUseSavesdirectory();
	afx_msg void OnUpdateOptionsShowperfomanceonstatusbar(CCmdUI* pCmdUI);
	afx_msg void OnOptionsShowperfomanceonstatusbar();
	afx_msg void OnFileLoadstate();
	afx_msg void OnFileSavestate();
	afx_msg void OnFileLoadtape();
	afx_msg void OnFilePrint();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnUpdateDebugBreak(CCmdUI* pCmdUI);
	afx_msg void OnDebugBreak();
	afx_msg void OnCpuNormalspeed();
	afx_msg void OnUpdateCpuRunbk001001Fdd16k(CCmdUI* pCmdUI);
	afx_msg void OnCpuRunbk001001Fdd16k();
	afx_msg void OnOptionsDiskimagemanager();
	afx_msg void OnDebugStepinto();
	afx_msg void OnDebugStepover();
	afx_msg void OnDebugStepout();
	afx_msg void OnDebugRuntocursor();
	afx_msg void OnUpdateDebugStepinto(CCmdUI* pCmdUI);
	afx_msg void OnUpdateDebugStepover(CCmdUI* pCmdUI);
	afx_msg void OnUpdateDebugStepout(CCmdUI* pCmdUI);
	afx_msg void OnUpdateDebugRuntocursor(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewPreserveCurrentMode(CCmdUI* pCmdUI);
	afx_msg void OnViewPreserveCurrentMode();
	afx_msg void OnPaletteChanged(CWnd* pFocusWnd);
	afx_msg void OnUpdateOptionsEmulateTapeLoading(CCmdUI* pCmdUI);
	afx_msg void OnOptionsEmulateTapeLoading();
	afx_msg void OnUpdateOptionsEmulateTapeSaving(CCmdUI* pCmdUI);
	afx_msg void OnOptionsEmulateTapeSaving();
	afx_msg void OnUpdateFileLoadtape(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewTapeControl(CCmdUI* pCmdUI);
	afx_msg void OnViewTapeControl();
	afx_msg void OnUpdateViewDebugwindow(CCmdUI* pCmdUI);
	afx_msg void OnViewDebugwindow();
	afx_msg void OnUpdateViewMemorydump(CCmdUI* pCmdUI);
	afx_msg void OnViewMemorydump();
	afx_msg void OnUpdateDebugSetaddress(CCmdUI* pCmdUI);
	afx_msg void OnDebugSetaddress();
	afx_msg void OnEditTapeRecord();
	afx_msg void OnMeasureItem(int nIDCtl, LPMEASUREITEMSTRUCT lpMeasureItemStruct);
	afx_msg void OnOptionsTapemanager();
	afx_msg BOOL OnCopyData(CWnd* pWnd, COPYDATASTRUCT* pCopyDataStruct);
	afx_msg void OnDebugBreakpoint();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAINFRM_H__319682E3_05D4_477F_BC31_E4F752371A35__INCLUDED_)
