/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: MSFManager.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// MSFManager.h: interface for the CMSFManager class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MSFMANAGER_H__B595563B_BF1D_4A2D_9A76_2D057DB6150F__INCLUDED_)
#define AFX_MSFMANAGER_H__B595563B_BF1D_4A2D_9A76_2D057DB6150F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "MSF.h"

//////////////////////////////////////////////////////////////////////
class CMSFManager  
{
	CFile				m_fileMSF;
	BOOL				m_bOpenForLoad;
	MSF_FILE_HEADER		m_header;

	CArray<MSF_BLOCK_INFO, MSF_BLOCK_INFO&> m_blocks;

	BOOL				Seek (int nOffset, DWORD nFrom);
	BOOL				ReleaseFile ();

public:
	CMSFManager();
	virtual ~CMSFManager();

	BOOL				OpenFile (CString strPath, BOOL bLoad);
	void				SetType (DWORD type) {m_header.type = type;}
	DWORD				GetType () {return m_header.type;}
	void				SetVersion (DWORD version) {m_header.version = version;}
	DWORD				GetVersion () {return m_header.version;}
	void				SetConfiguration (DWORD configuration) {m_header.configuration = configuration;}
	DWORD				GetConfiguration () {return m_header.configuration;}
	BOOL				IsLoad () {return m_bOpenForLoad;}
	BOOL				IsSave () {return !m_bOpenForLoad;}

	BOOL				FindBlock (DWORD blockType, MSF_BLOCK_INFO* pBi);
	BOOL				SetBlockHeader (MSF_BLOCK_INFO* pBi);
	BOOL				GetBlockHeader (MSF_BLOCK_INFO* pBi);
	BOOL				SetBlockData (BYTE* pBuff, DWORD length);
	BOOL				GetBlockData (BYTE* pBuff, DWORD length);

	BOOL				SetBlockPreview (HBITMAP hScreenshot);
	BOOL				GetBlockPreview (HBITMAP* hScreenshot);
	BOOL				SetBlockBaseMemory (BYTE* pMemory);
	BOOL				GetBlockBaseMemory (BYTE* pMemory);
	BOOL				SetBlockCPURegisters (MSF_CPU_REGISTERS* pCPURegisters);
	BOOL				GetBlockCPURegisters (MSF_CPU_REGISTERS* pCPURegisters);
	BOOL				SetBlockExt32Memory (DWORD nPage, BYTE* pMemoryExt);
	BOOL				GetBlockExt32Memory (DWORD* pnPage, BYTE* pMemoryExt);
	BOOL				SetBlockExt16Memory (BOOL bBasic, BYTE* pMemoryBasic, BYTE* pMemoryExt);
	BOOL				GetBlockExt16Memory (BOOL* pbBasic, BYTE* pMemoryBasic, BYTE* pMemoryExt);
	BOOL				SetBlockTape (BYTE* pPackedWave, DWORD nBitsLength, DWORD nPackLength);
	BOOL				GetBlockTape (BYTE* pPackedWave, DWORD* pnBitsLength, DWORD* pnPackLength);
};

#endif // !defined(AFX_MSFMANAGER_H__B595563B_BF1D_4A2D_9A76_2D057DB6150F__INCLUDED_)
