/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: MSF.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// MSF.h: interface for the COperand class.
//
//////////////////////////////////////////////////////////////////////


#if !defined (MSF_H)
#define MSF_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

enum {MSF_CONF_BK1001 = 1, MSF_CONF_BK1001_MSTD, MSF_CONF_BK1001_EXT32, MSF_CONF_BK1001_FDD, MSF_CONF_BK11M};
enum {MSF_BLOCKTYPE_UNKNOWN = - 1, MSF_BLOCKTYPE_BASEMEMORY = 0, MSF_BLOCKTYPE_CPU_REGISTERS, MSF_BLOCKTYPE_PREVIEW, MSF_BLOCKTYPE_10EXT16
, MSF_BLOCKTYPE_10EXT32, MSF_BLOCKTYPE_11EXT64, MSF_BLOCKTYPE_WAVE = 200};
enum {MSF_BLOCK_OBJECT_HEADER = 1000};

enum {MSF_STATE_ID = 65536};

//////////////////////////////////////////////////////////////////////
struct MSF_FILE_HEADER
{
	DWORD				type;
	DWORD				version;
	DWORD				configuration;
};

struct MSF_BLOCK_HEADER
{
	DWORD				type;
	DWORD				length;
};

struct MSF_CPU_REGISTERS
{
	WORD				r0;
	WORD				r1;
	WORD				r2;
	WORD				r3;
	WORD				r4;
	WORD				r5;
	WORD				sp;
	WORD				pc;
	WORD				psw;
};

struct MSF_BLOCK_INFO
{
	DWORD				offset;
	MSF_BLOCK_HEADER		header;
};

#endif // !defined(MSF_H)