/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: LoadTapeDlg.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// LoadTapeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "bk.h"
#include "Globals.h"
#include "LoadTapeDlg.h"
#include "BKDialog.h"
#include "Tape.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLoadTapeDlg

IMPLEMENT_DYNAMIC(CLoadTapeDlg, CFileDialog)

CLoadTapeDlg::CLoadTapeDlg(BOOL bOpenFileDialog, LPCTSTR lpszDefExt, LPCTSTR lpszFileName,
		DWORD dwFlags, LPCTSTR lpszFilter, CWnd* pParentWnd) :
		CFileDialog(bOpenFileDialog, lpszDefExt, lpszFileName, dwFlags, lpszFilter, pParentWnd)
{
	m_ofn.hwndOwner = pParentWnd->m_hWnd;
	m_ofn.Flags = OFN_EXPLORER|OFN_ENABLEHOOK|OFN_ENABLETEMPLATE;
	m_ofn.lpTemplateName = MAKEINTRESOURCE (IDD_LOAD_TAPE);
	m_ofn.lpfnHook = OFNHookProcOldStyle;
	m_ofn.lCustData = (LPARAM)this;
}


BEGIN_MESSAGE_MAP(CLoadTapeDlg, CFileDialog)
	//{{AFX_MSG_MAP(CLoadTapeDlg)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
UINT_PTR CALLBACK CLoadTapeDlg::OFNHookProcOldStyle (HWND hdlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uiMsg)
	{
	case WM_INITDIALOG:
		break;

	case WM_NOTIFY:
		{
			CBKDialog::ChangeCommonDialogFont (::GetParent (hdlg));

			LPNMHDR pNm;
			pNm = (LPNMHDR)lParam;

			LPOFNOTIFY pOFN = (LPOFNOTIFY)lParam;

			if (pNm->code == CDN_SELCHANGE)
			{	
				CString strPath;
				HWND hParent = ::GetParent (hdlg);
				::SendMessage (hParent, CDM_GETFILEPATH, 1024, (LPARAM)strPath.GetBufferSetLength (1024));
				strPath.ReleaseBuffer ();

				DrawPreview (hdlg, strPath);

				return 0;
			}
		}
		break;
	}

	return 0;
}



/////////////////////////////////////////////////////////////////////////////
void CLoadTapeDlg::DrawPreview (HWND hdlg, CString strPath)
{
	static CTape tape;

	CWnd* pDlg = CWnd::FromHandle (hdlg);
	CWnd* pWnd = NULL;

	if (!tape.LoadWaveFile (strPath))
		if (!tape.LoadMSFFile (strPath))
			return;
		
	// Set preview controls

	// Get current wave file information
	TAPE_FILE_INFO tfi;
	tape.GetWaveFile (&tfi, TRUE);
	
	// Set file name
	CString strName;
	TCHAR* pName = strName.GetBufferSetLength (sizeof (tfi.name) + 1);
	memcpy (pName, tfi.name, sizeof (tfi.name));
	pName[sizeof (tfi.name)] = 0;
	strName.ReleaseBuffer ();

	pWnd = pDlg->GetDlgItem (IDC_LT_NAME);
	pWnd->SetWindowText (BKToANSI (strName));

	CString strWord;
	
	// Set file address
	strWord = WordToOctString (tfi.address);

	pWnd = pDlg->GetDlgItem (IDC_LT_ADDRESS);
	pWnd->SetWindowText (strWord);

	// Set file length
	strWord = WordToOctString (tfi.length);

	pWnd = pDlg->GetDlgItem (IDC_LT_LENGTH);
	pWnd->SetWindowText (strWord);

}
