/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: LoadMemoryDlg.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// LoadMemoryDlg.cpp : implementation file
//

#include "stdafx.h"
#include "bk.h"
#include "MSF.h"
#include "LoadMemoryDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLoadMemoryDlg

IMPLEMENT_DYNAMIC(CLoadMemoryDlg, CFileDialog)

CLoadMemoryDlg::CLoadMemoryDlg(BOOL bOpenFileDialog, LPCTSTR lpszDefExt, LPCTSTR lpszFileName,
		DWORD dwFlags, LPCTSTR lpszFilter, CWnd* pParentWnd) :
		CFileDialog(bOpenFileDialog, lpszDefExt, lpszFileName, dwFlags, lpszFilter, pParentWnd)
{
	m_ofn.hwndOwner = pParentWnd->m_hWnd;
	m_ofn.Flags = OFN_EXPLORER|OFN_ENABLEHOOK|OFN_ENABLETEMPLATE;
	m_ofn.lpTemplateName = MAKEINTRESOURCE (IDD_LOAD_MEMORY);
	m_ofn.lpfnHook = OFNHookProcOldStyle;
	m_ofn.lCustData = (LPARAM)this;
}


BEGIN_MESSAGE_MAP(CLoadMemoryDlg, CFileDialog)
	//{{AFX_MSG_MAP(CLoadMemoryDlg)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////
UINT_PTR CALLBACK CLoadMemoryDlg::OFNHookProcOldStyle (HWND hdlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uiMsg)
	{
	case WM_INITDIALOG:
		break;

	case WM_NOTIFY:
		{
			CBKDialog::ChangeCommonDialogFont (::GetParent (hdlg));

			LPNMHDR pNm;
			pNm = (LPNMHDR)lParam;

			LPOFNOTIFY pOFN = (LPOFNOTIFY)lParam;

			if (pNm->code == CDN_SELCHANGE)
			{	
				CString strPath;
				HWND hParent = ::GetParent (hdlg);
				::SendMessage (hParent, CDM_GETFILEPATH, 1024, (LPARAM)strPath.GetBufferSetLength (1024));
				strPath.ReleaseBuffer ();

				DrawPreview (hdlg, strPath);

				return 0;
			}
		}
		break;
	}

	return 0;
}



/////////////////////////////////////////////////////////////////////////////
void CLoadMemoryDlg::DrawPreview (HWND hdlg, CString strPath)
{
	static CBitmap bm;

	CFile file;
	if (file.Open (strPath, CFile::modeRead))
	{
		int curPos = 0;
		int fileLength = file.GetLength ();

		MSF_FILE_HEADER sfh;
		file.Read (&sfh, sizeof (MSF_FILE_HEADER));
		curPos += sizeof (MSF_FILE_HEADER);

		if (sfh.type == MSF_STATE_ID && sfh.version >= 10)
		{
			MSF_BLOCK_HEADER bh;
			bh.type = MSF_BLOCKTYPE_UNKNOWN;
			bh.length = sizeof (bh);
			
			while (bh.type != MSF_BLOCKTYPE_PREVIEW)
			{
				file.Seek (bh.length - sizeof (bh), SEEK_CUR);
				file.Read (&bh, sizeof (bh));
				curPos += bh.length;

				if (curPos >= fileLength)
					return;
			}
			
			BITMAPINFOHEADER bmih;
			file.Read (&bmih, sizeof (BITMAPINFOHEADER));

			int bpr = (bmih.biWidth * (bmih.biBitCount / 8) + 3) / 4 * 4;
			int length = bpr * bmih.biHeight;

			void* pBits;
			HBITMAP hBm = ::CreateDIBSection (NULL, (BITMAPINFO*)&bmih, DIB_RGB_COLORS, (void**)&pBits, NULL, 0);
			file.Read (pBits, length);

			CWnd dlg;
			dlg.Attach (hdlg);

			CClientDC dc(&dlg);
			CDC memDC;
			memDC.CreateCompatibleDC (&dc);
			HBITMAP hOld = (HBITMAP)memDC.SelectObject (hBm);

			CWnd* pWnd = dlg.GetDlgItem (IDC_PREVIEW_BORDER);
			
			CRect rcPreview;
			pWnd->GetWindowRect (&rcPreview);
			dlg.ScreenToClient (rcPreview);
			rcPreview.DeflateRect (1, 1);

			int oldMode = dc.SetStretchBltMode (STRETCH_DELETESCANS);
			dc.StretchBlt (rcPreview.left, rcPreview.top, rcPreview.Width (), rcPreview.Height (), 
				&memDC, 0, 0, bmih.biWidth, bmih.biHeight, SRCCOPY);
			dc.SetStretchBltMode (oldMode);
			memDC.SelectObject (hOld);

			dlg.Detach ();
			::DeleteObject (hBm);
		}

		file.Close ();
	}
}