/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: ImageManagerDlg.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




#if !defined(AFX_IMAGEMANAGERDLG_H__CA002CE4_18C4_4821_A8C7_AE494AAD66D8__INCLUDED_)
#define AFX_IMAGEMANAGERDLG_H__CA002CE4_18C4_4821_A8C7_AE494AAD66D8__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ImageManagerDlg.h : header file
//

#include "BKDialog.h"

/////////////////////////////////////////////////////////////////////////////
// CImageManagerDlg dialog

class CImageManagerDlg : public CBKDialog
{
	CString				m_strExts[2];
	CString				m_strDrives[4];
	BOOL				m_bInverseSort[4];

	void				RefreshList ();
	void				GetImgFormat (CString strImageName, CString& strFormatName, CString& strSystemFlag);
	void				ReadDrivesPath ();
	void				SaveDrivesPath ();
	int					GetSelectedItem ();

	static int CALLBACK SortByDrive (LPARAM lParam1, LPARAM lParam2, CImageManagerDlg* pThis);
	static int CALLBACK SortByName (LPARAM lParam1, LPARAM lParam2, CImageManagerDlg* pThis);
	static int CALLBACK SortByFormat (LPARAM lParam1, LPARAM lParam2, CImageManagerDlg* pThis);
	static int CALLBACK SortBySystem (LPARAM lParam1, LPARAM lParam2, CImageManagerDlg* pThis);
	
// Construction
public:
	CImageManagerDlg(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CImageManagerDlg)
	enum { IDD = IDD_IMG_MANAGER };
	CListCtrl	m_imgList;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CImageManagerDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CImageManagerDlg)
	afx_msg void OnRclickImgmanagerImgList(NMHDR* pNMHDR, LRESULT* pResult);
	virtual BOOL OnInitDialog();
	afx_msg void OnColumnclickImgmanagerImgList(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnUpdateImgmanagerDrivea(CCmdUI* pCmdUI);
	afx_msg void OnImgmanagerDrivea();
	afx_msg void OnUpdateImgmanagerDriveb(CCmdUI* pCmdUI);
	afx_msg void OnImgmanagerDriveb();
	afx_msg void OnUpdateImgmanagerDrivec(CCmdUI* pCmdUI);
	afx_msg void OnImgmanagerDrivec();
	afx_msg void OnUpdateImgmanagerDrived(CCmdUI* pCmdUI);
	afx_msg void OnImgmanagerDrived();
	afx_msg void OnImgmanagerClear();
	//}}AFX_MSG
	virtual void OnOK ();
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_IMAGEMANAGERDLG_H__CA002CE4_18C4_4821_A8C7_AE494AAD66D8__INCLUDED_)
