/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: ImageManagerDlg.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// ImageManagerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "bk.h"
#include "Globals.h"
#include "ImageManagerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CBKApp theApp;
/////////////////////////////////////////////////////////////////////////////
// CImageManagerDlg dialog


CImageManagerDlg::CImageManagerDlg(CWnd* pParent /*=NULL*/)
	: CBKDialog(CImageManagerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CImageManagerDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_strExts[0] = "*.img";
	m_strExts[1] = "*.bkd";

	//memset (m_bInverseSort, 0, sizeof (m_bInverseSort) / sizeof (m_bInverseSort[0]));
}


void CImageManagerDlg::DoDataExchange(CDataExchange* pDX)
{
	CBKDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CImageManagerDlg)
	DDX_Control(pDX, IDC_IMGMANAGER_IMG_LIST, m_imgList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CImageManagerDlg, CBKDialog)
	//{{AFX_MSG_MAP(CImageManagerDlg)
	ON_NOTIFY(NM_RCLICK, IDC_IMGMANAGER_IMG_LIST, OnRclickImgmanagerImgList)
	ON_NOTIFY(LVN_COLUMNCLICK, IDC_IMGMANAGER_IMG_LIST, OnColumnclickImgmanagerImgList)
	ON_UPDATE_COMMAND_UI(ID_IMGMANAGER_DRIVEA, OnUpdateImgmanagerDrivea)
	ON_COMMAND(ID_IMGMANAGER_DRIVEA, OnImgmanagerDrivea)
	ON_UPDATE_COMMAND_UI(ID_IMGMANAGER_DRIVEB, OnUpdateImgmanagerDriveb)
	ON_COMMAND(ID_IMGMANAGER_DRIVEB, OnImgmanagerDriveb)
	ON_UPDATE_COMMAND_UI(ID_IMGMANAGER_DRIVEC, OnUpdateImgmanagerDrivec)
	ON_COMMAND(ID_IMGMANAGER_DRIVEC, OnImgmanagerDrivec)
	ON_UPDATE_COMMAND_UI(ID_IMGMANAGER_DRIVED, OnUpdateImgmanagerDrived)
	ON_COMMAND(ID_IMGMANAGER_DRIVED, OnImgmanagerDrived)
	ON_BN_CLICKED(ID_IMGMANAGER_CLEAR, OnImgmanagerClear)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CImageManagerDlg message handlers

void CImageManagerDlg::OnRclickImgmanagerImgList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CMenu menu;
	menu.LoadMenu (IDR_IMGMANAGER_MENU);

	CBKMenu menuBK;
	menuBK.Customize (&menu);
	CMenu* pSubMenu = menuBK.GetSubMenu (0);
	
	CPoint point;
	GetCursorPos (&point);

	pSubMenu->TrackPopupMenu (TPM_RIGHTBUTTON, point.x, point.y, this);
	
	*pResult = 0;
}



/////////////////////////////////////////////////////////////////////////////
BOOL CImageManagerDlg::OnInitDialog() 
{
	CBKDialog::OnInitDialog();
	
	m_imgList.SetExtendedStyle (LVS_EX_FULLROWSELECT);
	m_imgList.InsertColumn (0, "Drive", LVCFMT_LEFT, 40);
	m_imgList.InsertColumn (1, "Image name", LVCFMT_LEFT, 120);
	m_imgList.InsertColumn (2, "Format", LVCFMT_LEFT, 100);
	m_imgList.InsertColumn (3, "Boot", LVCFMT_LEFT, 100);
	
	ReadDrivesPath ();
	RefreshList ();


	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}



/////////////////////////////////////////////////////////////////////////////
void CImageManagerDlg::RefreshList ()
{
	m_imgList.DeleteAllItems ();
	
	int nItem = 0;
	CString strImgDir;
	strImgDir.LoadString (IDS_IMG_DIRECTORY);
	CString strCurPath;
	strCurPath = GetCurrentPath () + strImgDir;
	
	CFileFind ff;

	// Find images of any defined extensions
	for (int e = 0; e <= sizeof (m_strExts) / sizeof (m_strExts[0]); e++)
	{
		BOOL bRes = ff.FindFile (strCurPath + m_strExts[e]);
		
		while (bRes)
		{
			bRes = ff.FindNextFile ();

			CString strName = ff.GetFileName ();
			CString strDrive = "";

			// Get drive letter first
			for (int i = 0; i < sizeof (m_strDrives) / sizeof (m_strDrives[0]); i++)
			{
				if (!m_strDrives[i].CompareNoCase (strImgDir + strName))
				{
					char letter = 'A' + i;
					strDrive = letter + CString (":");
					break;
				}
			}

			// then get Image format and system flag
			CString strDiskFormat;
			CString strSystemFlag;
			GetImgFormat (strCurPath + strName, strDiskFormat, strSystemFlag);

			m_imgList.InsertItem (nItem, NULL);
			m_imgList.SetItem (nItem, 0, LVIF_TEXT, strDrive, 0, 0, 0, NULL);
			m_imgList.SetItem (nItem, 1, LVIF_TEXT, strName, 0, 0, 0, NULL);
			m_imgList.SetItem (nItem, 2, LVIF_TEXT, strDiskFormat, 0, 0, 0, NULL);
			m_imgList.SetItem (nItem, 3, LVIF_TEXT, strSystemFlag, 0, 0, 0, NULL);
			nItem++;
		}
	}

	m_imgList.SortItems ((PFNLVCOMPARE)SortByName, (UINT)this);
}



//////////////////////////////////////////////////////////////////////
void CImageManagerDlg::GetImgFormat (CString strImageName, CString& strFormatName, CString& strSystemFlag)
{	
	strFormatName.LoadString (IDS_DISK_FORMAT_UNKNOWN);
	strSystemFlag = "";

	CFile file;
	if (!file.Open (strImageName, CFile::modeRead))
		return;
	
	BYTE pImg[512];

	if (file.Read (pImg, 512) < 512)
		return;
	
	// Get image system flag
	if (*(WORD*)pImg == 0240 /*NOP*/)
		if (*(WORD*)&pImg[2] != 5 /*RESET*/)
			strSystemFlag.LoadString (IDS_DISK_SYSTEM);

	// Get image format
	if (*(WORD*)&pImg[0400] == 0123456)
	{
		if (*(WORD*)&pImg[0402] == 051414)
		{
			strFormatName.LoadString (IDS_DISK_FORMAT_MKDOS);
			return;
		}

		strFormatName.LoadString (IDS_DISK_FORMAT_MICRODOS);
		return;
	}

	CString strID;
	strID.LoadString (IDS_DISK_FORMAT_ANDOS);
	strID += "  ";

	if (!strID.CollateNoCase ((LPCSTR)&pImg[4]))
	{
		strFormatName.LoadString (IDS_DISK_FORMAT_ANDOS);
		return;
	}
}



//////////////////////////////////////////////////////////////////////
void CImageManagerDlg::ReadDrivesPath ()
{
	CString strIniFileName;
	strIniFileName.LoadString (IDS_INI_FILENAME);
	
	m_strDrives[0] = GetIniFileString (IDS_INI_DRIVES, IDS_INI_DRIVEA, GetCurrentPath () + strIniFileName);
	m_strDrives[1] = GetIniFileString (IDS_INI_DRIVES, IDS_INI_DRIVEB, GetCurrentPath () + strIniFileName);
	m_strDrives[2] = GetIniFileString (IDS_INI_DRIVES, IDS_INI_DRIVEC, GetCurrentPath () + strIniFileName);
	m_strDrives[3] = GetIniFileString (IDS_INI_DRIVES, IDS_INI_DRIVED, GetCurrentPath () + strIniFileName);
}



//////////////////////////////////////////////////////////////////////
void CImageManagerDlg::SaveDrivesPath ()
{
	LVFINDINFO fi;
	fi.flags = LVFI_STRING;
	
	int iItem = -1;
	CString srtName;
	CString strImgDir;
	strImgDir.LoadString (IDS_IMG_DIRECTORY);
	CString strIniFileName;
	strIniFileName.LoadString (IDS_INI_FILENAME);
	
	fi.psz = "A:";
	srtName = "";
	iItem = m_imgList.FindItem (&fi);
	if (iItem != -1)
		srtName = m_imgList.GetItemText (iItem, 1);
	
	SetIniFileString (strImgDir + srtName, IDS_INI_DRIVES, IDS_INI_DRIVEA, GetCurrentPath () + strIniFileName);

	fi.psz = "B:";
	srtName = "";
	iItem = m_imgList.FindItem (&fi);
	if (iItem != -1)
		srtName = m_imgList.GetItemText (iItem, 1);
	
	SetIniFileString (strImgDir + srtName, IDS_INI_DRIVES, IDS_INI_DRIVEB, GetCurrentPath () + strIniFileName);

	fi.psz = "C:";
	srtName = "";
	iItem = m_imgList.FindItem (&fi);
	if (iItem != -1)
		srtName = m_imgList.GetItemText (iItem, 1);
	
	SetIniFileString (strImgDir + srtName, IDS_INI_DRIVES, IDS_INI_DRIVEC, GetCurrentPath () + strIniFileName);

	fi.psz = "D:";
	srtName = "";
	iItem = m_imgList.FindItem (&fi);
	if (iItem != -1)
		srtName = m_imgList.GetItemText (iItem, 1);
	
	SetIniFileString (strImgDir + srtName, IDS_INI_DRIVES, IDS_INI_DRIVED, GetCurrentPath () + strIniFileName);
}



//////////////////////////////////////////////////////////////////////
int	CImageManagerDlg::GetSelectedItem ()
{
	POSITION pos = m_imgList.GetFirstSelectedItemPosition ();

	if (!pos)
		return -1;

	return m_imgList.GetNextSelectedItem(pos);
}



//////////////////////////////////////////////////////////////////////
void CImageManagerDlg::OnColumnclickImgmanagerImgList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	if (pNMListView->iItem == -1)
	{
		// Realign all indexes
		int nCount = m_imgList.GetItemCount ();
		for (int i = 0; i < nCount; i++)
			m_imgList.SetItemData (i, i);

		// Invert sort order
		m_bInverseSort[pNMListView->iSubItem] = !m_bInverseSort[pNMListView->iSubItem];

		// Call necessery sort function
		switch (pNMListView->iSubItem)
		{
		case 0:
			m_imgList.SortItems ((PFNLVCOMPARE)SortByDrive, (UINT)this);
			break;
		case 1:
			m_imgList.SortItems ((PFNLVCOMPARE)SortByName, (UINT)this);
			break;
		case 2:
			m_imgList.SortItems ((PFNLVCOMPARE)SortByFormat, (UINT)this);
			break;
		case 3:
			m_imgList.SortItems ((PFNLVCOMPARE)SortBySystem, (UINT)this);
			break;
		default:
			break;
		}
	}

	*pResult = 0;
}



//////////////////////////////////////////////////////////////////////
int CALLBACK CImageManagerDlg::SortByName (LPARAM lParam1, LPARAM lParam2, CImageManagerDlg* pThis)
{
	CString strItem1 = pThis->m_imgList.GetItemText (lParam1, 1);
	CString strItem2 = pThis->m_imgList.GetItemText (lParam2, 1);

	int bRes = strItem1.CollateNoCase (strItem2);

	if (pThis->m_bInverseSort[1])
		bRes *= -1;

	return bRes;
}



//////////////////////////////////////////////////////////////////////
int CALLBACK CImageManagerDlg::SortByDrive (LPARAM lParam1, LPARAM lParam2, CImageManagerDlg* pThis)
{
	CString strItem1 = pThis->m_imgList.GetItemText (lParam1, 0);
	CString strItem2 = pThis->m_imgList.GetItemText (lParam2, 0);

	int bRes = strItem1.CollateNoCase (strItem2);

	if (pThis->m_bInverseSort[0])
		bRes *= -1;

	return bRes;
}



//////////////////////////////////////////////////////////////////////
int CALLBACK CImageManagerDlg::SortByFormat (LPARAM lParam1, LPARAM lParam2, CImageManagerDlg* pThis)
{
	CString strItem1 = pThis->m_imgList.GetItemText (lParam1, 2);
	CString strItem2 = pThis->m_imgList.GetItemText (lParam2, 2);

	int bRes = strItem1.CollateNoCase (strItem2);

	if (pThis->m_bInverseSort[2])
		bRes *= -1;

	return bRes;
}



//////////////////////////////////////////////////////////////////////
int CALLBACK CImageManagerDlg::SortBySystem (LPARAM lParam1, LPARAM lParam2, CImageManagerDlg* pThis)
{
	CString strItem1 = pThis->m_imgList.GetItemText (lParam1, 3);
	CString strItem2 = pThis->m_imgList.GetItemText (lParam2, 3);

	int bRes = strItem1.CollateNoCase (strItem2);

	if (pThis->m_bInverseSort[3])
		bRes *= -1;

	return bRes;
}



//////////////////////////////////////////////////////////////////////
void CImageManagerDlg::OnUpdateImgmanagerDrivea(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable (GetSelectedItem () != -1);
}



//////////////////////////////////////////////////////////////////////
void CImageManagerDlg::OnImgmanagerDrivea() 
{
	LVFINDINFO fi;
	fi.flags = LVFI_STRING;
	fi.psz = "A:";
	int iSelected = GetSelectedItem ();
	int iItem = m_imgList.FindItem (&fi);

	if (iItem == -1 && iSelected == -1)
		return;
	
	m_imgList.SetItemText (iItem, 0, "");
	m_imgList.SetItemText (iSelected, 0, fi.psz);
}



//////////////////////////////////////////////////////////////////////
void CImageManagerDlg::OnUpdateImgmanagerDriveb(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable (GetSelectedItem () != -1);
}



//////////////////////////////////////////////////////////////////////
void CImageManagerDlg::OnImgmanagerDriveb() 
{
	LVFINDINFO fi;
	fi.flags = LVFI_STRING;
	fi.psz = "B:";
	int iSelected = GetSelectedItem ();
	int iItem = m_imgList.FindItem (&fi);

	if (iItem == -1 && iSelected == -1)
		return;
	
	m_imgList.SetItemText (iItem, 0, "");
	m_imgList.SetItemText (iSelected, 0, fi.psz);
}



//////////////////////////////////////////////////////////////////////
void CImageManagerDlg::OnUpdateImgmanagerDrivec(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable (GetSelectedItem () != -1);
}



//////////////////////////////////////////////////////////////////////
void CImageManagerDlg::OnImgmanagerDrivec() 
{
	LVFINDINFO fi;
	fi.flags = LVFI_STRING;
	fi.psz = "C:";
	int iSelected = GetSelectedItem ();
	int iItem = m_imgList.FindItem (&fi);

	if (iItem == -1 && iSelected == -1)
		return;
	
	m_imgList.SetItemText (iItem, 0, "");
	m_imgList.SetItemText (iSelected, 0, fi.psz);
}



//////////////////////////////////////////////////////////////////////
void CImageManagerDlg::OnUpdateImgmanagerDrived(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable (GetSelectedItem () != -1);
}



//////////////////////////////////////////////////////////////////////
void CImageManagerDlg::OnImgmanagerDrived() 
{
	LVFINDINFO fi;
	fi.flags = LVFI_STRING;
	fi.psz = "D:";
	int iSelected = GetSelectedItem ();
	int iItem = m_imgList.FindItem (&fi);

	if (iItem == -1 && iSelected == -1)
		return;
	
	m_imgList.SetItemText (iItem, 0, "");
	m_imgList.SetItemText (iSelected, 0, fi.psz);
}



//////////////////////////////////////////////////////////////////////
void CImageManagerDlg::OnOK ()
{
	SaveDrivesPath ();

	CBKDialog::OnOK ();
}



//////////////////////////////////////////////////////////////////////
void CImageManagerDlg::OnImgmanagerClear() 
{
	// Clear all drives
	int nCount = m_imgList.GetItemCount ();
	for (int i = 0; i < nCount; i++)
		m_imgList.SetItemText (i, 0, "");
}
