/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: Globals.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// Globals.h

#ifndef GLOBALS_H
#define GLOBALS_H

#include "Defines.h"

//////////////////////////////////////////////////////////////////////
CString			GetCurrentPath ();
CString&		NormalizePath (CString& strPath);
CString			GetFilePath (CString strPath);
CString			GetFileTitle (CString strPath);
CString			GetFileName (CString strPath);
CString			GetFileExt (CString strPath);
CString			GetIniFileString (int section, int key, CString strFileName);
void			SetIniFileString (CString str, int section, int key, CString strFileName);
BOOL			GetIniFileBool (int section, int key, CString strFileName);
int				GetIniFileInt (int section, int key, CString strFileName);
int				GetIniFileOct (int section, int key, CString strFileName);
float			GetIniFileFloat (int section, int key, CString strFileName);
CString			WordToOctString (WORD word);
WORD			OctStringToWord (CString str);
CString			IntToString (int iInt, int radix);
CString			IntToFileLengthString (LONGLONG iInt);
CString			MsTimeToTimeString (int msTime);
void			SumStretchBlt (HBITMAP hDst, HBITMAP hSrc);



//////////////////////////////////////////////////////////////////////
inline int GetDigit (WORD word, int pos)
{
	//return (word >>= pos * 3) % 8;
	return (word >>= ((pos << 1) + pos)) & 7;
}



//////////////////////////////////////////////////////////////////////
inline int ConvertAddress (int address)
{
	ASSERT ((address >= 0 && address < 65536) || (address >= R0 && address <= PC));

	if (address < R0 || address > PC)
		return address & 0177777;

	return 65536 + (address - R0);
}



//////////////////////////////////////////////////////////////////////
void BKToANSI (BYTE* pBuff, int size);
CString& BKToANSI (CString& str);
void ANSIToBK (BYTE* pBuff, int size);
CString& ANSIToBK (CString& str);
void ANSIToBK (TCHAR* pCh);

#endif GLOBALS_H

