/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: Globals.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




#include "StdAfx.h"
#include "Globals.h"

//////////////////////////////////////////////////////////////////////
CString GetCurrentPath ()
{
	TCHAR pDir[_MAX_DIR];
	TCHAR pPath[_MAX_PATH];
	TCHAR pModuleName[_MAX_PATH];
	
	::GetModuleFileName (AfxGetInstanceHandle (), pModuleName, _MAX_PATH);
	_tsplitpath (pModuleName, pDir, pPath, NULL, NULL);

	return CString (pDir) + CString (pPath);
}



//////////////////////////////////////////////////////////////////////
CString& NormalizePath (CString& strPath)
{
	if (!strPath.IsEmpty ())
	{
		strPath.TrimRight (_T('\\'));
		strPath += _T('\\');
	}

	return strPath;
}



//////////////////////////////////////////////////////////////////////
CString GetFilePath (CString strPath)
{
	TCHAR pDrive[_MAX_DRIVE];
	TCHAR pPath[_MAX_PATH];

	_tsplitpath (strPath, pDrive, pPath, NULL, NULL);

	return NormalizePath (CString (pDrive) + CString (pPath));
}



//////////////////////////////////////////////////////////////////////
CString GetFileTitle (CString strPath)
{
	TCHAR pName[_MAX_FNAME];

	_tsplitpath (strPath, NULL, NULL, pName, NULL);

	return CString (pName);
}



//////////////////////////////////////////////////////////////////////
CString GetFileName (CString strPath)
{
	TCHAR pName[_MAX_FNAME];
	TCHAR pExt[_MAX_EXT];

	_tsplitpath (strPath, NULL, NULL, pName, pExt);

	return CString (pName) + CString (pExt);
}



//////////////////////////////////////////////////////////////////////
CString	GetFileExt (CString strPath)
{
	TCHAR pExt[_MAX_EXT];

	_tsplitpath (strPath, NULL, NULL, NULL, pExt);

	return CString (pExt);
}



//////////////////////////////////////////////////////////////////////
CString	GetIniFileString (int section, int key, CString strFileName)
{
	CString strParam;
	CString strSectionName, strKeyName;

	strSectionName.LoadString (section);
	strKeyName.LoadString (key);
	int nFound = ::GetPrivateProfileString (strSectionName, strKeyName, _T(""), strParam.GetBufferSetLength (256), 256, strFileName);
	strParam.ReleaseBuffer ();

	ASSERT (nFound);

	return strParam;
}



//////////////////////////////////////////////////////////////////////
void SetIniFileString (CString str, int section, int key, CString strFileName)
{
	CString strSectionName, strKeyName;
	strSectionName.LoadString (section);
	strKeyName.LoadString (key);
	
	::WritePrivateProfileString (strSectionName, strKeyName, str, strFileName);
}



//////////////////////////////////////////////////////////////////////
BOOL GetIniFileBool (int section, int key, CString strFileName)
{
	CString strParam;
	CString strSectionName, strKeyName;

	strSectionName.LoadString (section);
	strKeyName.LoadString (key);
	int nFound = ::GetPrivateProfileString (strSectionName, strKeyName, _T(""), strParam.GetBufferSetLength (256), 256, strFileName);
	strParam.ReleaseBuffer ();

	ASSERT (nFound);

	if (!strParam.CompareNoCase (_T("yes")))
		return TRUE;

	return FALSE;
}



//////////////////////////////////////////////////////////////////////
int	GetIniFileInt (int section, int key, CString strFileName)
{
	CString strParam;
	CString strSectionName, strKeyName;

	strSectionName.LoadString (section);
	strKeyName.LoadString (key);
	int nFound = ::GetPrivateProfileString (strSectionName, strKeyName, _T(""), strParam.GetBufferSetLength (256), 256, strFileName);
	strParam.ReleaseBuffer ();

	ASSERT (nFound);

	return _ttoi (strParam);
}



//////////////////////////////////////////////////////////////////////
int	GetIniFileOct (int section, int key, CString strFileName)
{
	CString strParam;
	CString strSectionName, strKeyName;

	strSectionName.LoadString (section);
	strKeyName.LoadString (key);
	int nFound = ::GetPrivateProfileString (strSectionName, strKeyName, "", strParam.GetBufferSetLength (256), 256, strFileName);
	strParam.ReleaseBuffer ();

	ASSERT (nFound);

	int oct = 0;
	sscanf (strParam, "%o", &oct);
	return oct;
}



//////////////////////////////////////////////////////////////////////
float GetIniFileFloat (int section, int key, CString strFileName)
{
	CString strParam;
	CString strSectionName, strKeyName;
	strSectionName.LoadString (section);
	strKeyName.LoadString (key);

	::GetPrivateProfileString (strSectionName, strKeyName, _T(""), strParam.GetBufferSetLength (256), 256, strFileName);
	strParam.ReleaseBuffer ();

	TCHAR* pStopScan;
	return (float)_tcstod (strParam, &pStopScan);	
}



//////////////////////////////////////////////////////////////////////
CString	WordToOctString (WORD word)
{
	CString strOct;

	while (word >= 8)
	{
		strOct = CString (_T('0') + word % 8) + strOct;
		word /= 8;
	}

	strOct = CString (_T('0') + word) + strOct;

	return strOct;
}



//////////////////////////////////////////////////////////////////////
WORD OctStringToWord (CString str)
{
	int length = str.GetLength ();
	int word = 0;
	
	if (length)
	{
		for (int i = 0; i < length - 1; i++)
		{
			int p = 1;

			for (int k = 0; k < length - i - 1; k++)
				p *= 8;

			word += (str[i] - '0') * p;
		}

		word += str[length - 1] - '0';
	}

	return word;
}



//////////////////////////////////////////////////////////////////////
CString	IntToString (int iInt, int radix)
{	
	CString str;
	_itot (iInt, str.GetBufferSetLength (256), radix);
	str.ReleaseBuffer ();

	return str;
}



//////////////////////////////////////////////////////////////////////
CString	IntToFileLengthString (LONGLONG iInt)
{
	CString str;

	while (iInt >= 1000)
	{
		CString strTriple = IntToString (iInt % 1000, 10);
		str = strTriple + str;
		str = _T(" ") + str;

		iInt /= 1000;
	}

	CString strTriple = IntToString (iInt, 10);
	str = strTriple + str;

	return str;
}



//////////////////////////////////////////////////////////////////////
CString MsTimeToTimeString (int msTime)
{
	CString strMin = IntToString (msTime / 60000, 10);
	CString strSec;
	strSec.Format (_T("%02i"), msTime / 1000 % 60);

	return strMin + _T(':') + strSec;
}



//////////////////////////////////////////////////////////////////////
void SumStretchBlt (HBITMAP hDst, HBITMAP hSrc)
{
	BITMAP infoSrc, infoDst;
	::GetObject (hSrc, sizeof (infoSrc), &infoSrc);
	::GetObject (hDst, sizeof (infoDst), &infoDst);

	COLORREF* pSrcBits = (COLORREF*)infoSrc.bmBits;
	COLORREF* pDstBits = (COLORREF*)infoDst.bmBits;

	int yBlockBeg = 0;
	for (int y = 0; y < infoDst.bmHeight; y++)
	{
		COLORREF* pDstRow = pDstBits + infoDst.bmWidth * y;
		int xBlockBeg = 0;
		int yBlockLength = (y + 1) * (infoSrc.bmHeight) / (infoDst.bmHeight) - yBlockBeg; 
			
		for (int x = 0; x < infoDst.bmWidth; x++)
		{
			int xBlockLength = (x + 1) * (infoSrc.bmWidth) / (infoDst.bmWidth) - xBlockBeg;
			int sumR = 0;
			int sumG = 0;
			int sumB = 0;

			for (int yb = 0; yb < max (1, yBlockLength); yb++)
			{
				COLORREF* pSrcRow = pSrcBits + infoSrc.bmWidth * (yb + yBlockBeg) + xBlockBeg;

				for (int xb = 0; xb < max (1, xBlockLength); xb++)
				{
					sumR += GetRValue (pSrcRow[xb]);
					sumG += GetGValue (pSrcRow[xb]);
					sumB += GetBValue (pSrcRow[xb]);
				}
					
			}

			pDstRow[x] = RGB (
				sumR / (max (1, xBlockLength) * max (1, yBlockLength)),
				sumG / (max (1, xBlockLength) * max (1, yBlockLength)),
				sumB / (max (1, xBlockLength) * max (1, yBlockLength)));
			
			xBlockBeg += xBlockLength;
		}

		yBlockBeg += yBlockLength;
	}
}



/////////////////////////////////////////////////////////////////////////////
void BKToANSI (BYTE* pBuff, int size)
{
	BYTE bk_codes[] = {
		'', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
		'', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
		'', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
		'', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''};

	for (int i = 0; i < size; i++)
	{
		if (pBuff[i] == 9)
		{
			pBuff[i] = '\t';
			continue;		
		}	

		if (pBuff[i] == 10)
		{
			pBuff[i] = '\n';
			continue;
		}

		if (pBuff[i] < 32)
		{
			pBuff[i] = ' ';
			continue;
		}

		if (pBuff[i] >= 32 && pBuff[i] <= 127)
			continue;

		if (pBuff[i] >= 192)
		{
			pBuff[i] = bk_codes[pBuff[i] - 192];
			continue;
		}
	}
}



/////////////////////////////////////////////////////////////////////////////
CString& BKToANSI (CString& str)
{
	BKToANSI ((BYTE*)(str.GetBuffer (str.GetLength ())), str.GetLength ());

	return str;
}



/////////////////////////////////////////////////////////////////////////////
void ANSIToBK (BYTE* pBuff, int size)
{
	BYTE bk_codes[] = {
		'', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
		'', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
		'', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
		'', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''};

	for (int i = 0; i < size; i++)
	{
		if (pBuff[i] == _T('\t'))
		{
			pBuff[i] = 9;
			continue;		
		}	

		if (pBuff[i] == _T('\n'))
		{
			pBuff[i] = 10;
			continue;
		}

		/*
		if (pBuff[i] < 32)
		{
			pBuff[i] = _T(' ');
			continue;
		}
		*/

		if (pBuff[i] >= 32 && pBuff[i] <= 127)
			continue;

		if (pBuff[i] >= 192)
		{
			pBuff[i] = bk_codes[pBuff[i] - 192];
			continue;
		}
	}
}



/////////////////////////////////////////////////////////////////////////////
CString& ANSIToBK (CString& str)
{
	ANSIToBK ((BYTE*)(str.GetBuffer (str.GetLength ())), str.GetLength ());
	
	return str;
}



/////////////////////////////////////////////////////////////////////////////
void ANSIToBK (TCHAR* pCh)
{
	ANSIToBK ((BYTE*)pCh, 1);
}