/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: Floater.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




#if !defined(AFX_FLOATER_H__8B7A9B6A_AF10_403C_851F_20C8E0DCA046__INCLUDED_)
#define AFX_FLOATER_H__8B7A9B6A_AF10_403C_851F_20C8E0DCA046__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// Floater.h : header file
//

/////////////////////////////////////////////////////////////////////////////
class CPanel;

typedef CPanel* (*PANELFACTORY_LAYOUT) (CWnd* pWnd);
typedef CPanel* (*PANELFACTORY_DOUBLE) (const TCHAR* pName, double size);
typedef CPanel* (*PANELFACTORY_INT) (const TCHAR* pName, int size);

/////////////////////////////////////////////////////////////////////////////
// CFloater window

class CFloater : public CWnd
{
	enum {ALIGN_NOWHERE = -1, ALIGN_RIGHT = 0, ALIGN_LEFT, ALIGN_BOTTOM, ALIGN_TOP};
	enum {ALIGN_HOR = ALIGN_RIGHT, ALIGN_VER = ALIGN_BOTTOM};
	
	enum {DEFAULT_CAPTION_SIZE = 10};

	BOOL				m_bFloat;
	int					m_fAligned;
	int					m_fLastAligned;
	BOOL				m_bFixedSize;
	BOOL				m_bEnableSplitter;
	BOOL				m_bDrawDebugInfo;		// flag draw or not debug panel information
	int					m_fDockingPriority;

	double				m_dockingSize;
	int					m_fixedDockingSize;
	int					m_captionSize;

	BOOL				m_bMoveSplitter;
	CPoint				m_ptInitPos;
	CPoint				m_ptOldPos;
	CPoint				m_ptEndPos;

	PANELFACTORY_DOUBLE m_pDoubleFactory;
	PANELFACTORY_INT	m_pIntFactory;
	CWnd*				m_pWnd;
	CWnd*				m_pParentWnd;
	CPanel*				m_pLayout;
	CPanel*				m_pFloaterLayout;

	CPanel*				m_pWrapperPanel;
	CPanel*				m_pDockPanel;
	CPanel*				m_pLastDockPanel;
	CRect				m_rcPanel;
	CRect				m_rcWindow;
	
protected:

	virtual void		OnDrawCaption (CDC* pDC, CRect& rcBound);	// Called then caption drawing

	void				DrawDragMark (CPoint ptPos);
	void				RepositionFloater (CPoint ptPos);
	void				DockPanel ();

	int					GetPanelSide (CPoint& ptPos, CPanel* pPanel);

// Construction
public:
	CFloater();

// Attributes
public:

// Operations
public:
	// Make floater
	void				CreateFloater (CWnd* pParent, CPanel* pLayout, double dockingSize
		, PANELFACTORY_LAYOUT pLayoutFactory = NULL, PANELFACTORY_DOUBLE pDoubleFactory = NULL);
	void				CreateFloater (CWnd* pParent, CPanel* pLayout, int dockingSize
		, PANELFACTORY_LAYOUT pLayoutFactory = NULL, PANELFACTORY_INT pIntFactory = NULL);

	// Call this methods to draw debug info
	void				DrawDebugInfo (BOOL bEnabled);

	// Insert window in floater
	void				InsertWindow (CWnd* pWnd, int windowAlign);
	void				InsertWindow (CWnd* pWnd, int ctrlID, int windowAlign);
	void				InsertWindow (CWnd* pWnd, int firstID, int lastID, int windowAlign);

	// Change floater state
	void				EnableFloating (BOOL bFloat, CPoint ptPos, BOOL bShow = TRUE);
	
	// Splitter functions
	void				EnableSplitter ();
	void				DisableSplitter ();

	// Set/Get Docking parameters
	void				SetDockingSize (int size);
	void				SetDockingPriority (BOOL bVertical);
	int					GetDockingSize ();
	BOOL				GetDockingPriority ();
	void				DockFloater (CPanel* pPanel, int align, BOOL bShow);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFloater)
	public:
	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL


// Implementation
public:
	virtual ~CFloater();

	// Generated message map functions
protected:
	//{{AFX_MSG(CFloater)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg UINT OnNcHitTest(CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnCaptureChanged(CWnd *pWnd);
	afx_msg void OnPaint();
	afx_msg void OnClose();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnNcCalcSize(BOOL bCalcValidRects, NCCALCSIZE_PARAMS FAR* lpncsp);
	afx_msg void OnNcPaint();
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_FLOATER_H__8B7A9B6A_AF10_403C_851F_20C8E0DCA046__INCLUDED_)
