/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: FDDController.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// FDDController.h: interface for the CFDDController class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FDDCONTROLLER_H__000B49F3_AF5D_4EC9_9CB9_0180ADD033E0__INCLUDED_)
#define AFX_FDDCONTROLLER_H__000B49F3_AF5D_4EC9_9CB9_0180ADD033E0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Globals.h"
#include "Device.h"

//////////////////////////////////////////////////////////////////////
class CFDDController : public CDevice  
{
	CString				m_strDrives[4];

public:
	CFDDController();
	virtual ~CFDDController();

	// Virtual method called after reset command
	virtual void		OnReset ();

	// Methods for Set/Get byte/word
	virtual void		GetByte (int addr, BYTE* pValue);
	virtual void		GetWord (int addr, WORD* pValue);
	virtual void		SetByte (int addr, BYTE value);
	virtual void		SetWord (int addr, WORD value);

	void				ReadDrivesPath ();
};

#endif // !defined(AFX_FDDCONTROLLER_H__000B49F3_AF5D_4EC9_9CB9_0180ADD033E0__INCLUDED_)
