/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: Dst.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// HighRes.h: interface for the CHighRes class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DST_H__3222C041_9BF9_4662_9966_942A413ED4ED__INCLUDED_)
#define AFX_DST_H__3222C041_9BF9_4662_9966_942A413ED4ED__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//////////////////////////////////////////////////////////////////////
#include <atlbase.h>


//////////////////////////////////////////////////////////////////////
class CDSTFailQueryInterfaceException
{
	HRESULT				m_hr;

public:
	CDSTFailQueryInterfaceException (HRESULT hr) {m_hr = hr;}
};



//////////////////////////////////////////////////////////////////////
class CDSTHResult  
{
	HRESULT				m_hr;

public:
	CDSTHResult ();
	virtual ~CDSTHResult ();

	CDSTHResult&		operator= (HRESULT hr);
	HRESULT				GetHResult (){return m_hr;}
	void				CheckInterface (IUnknown* unk);
};




//////////////////////////////////////////////////////////////////////
class CDSTSpy
{
	BOOL				m_bInit;
	DWORD				m_register;

public:
	CDSTSpy ();
	virtual ~CDSTSpy ();

	HRESULT				AddToRot (IUnknown *pUnkGraph);
	void				RemoveFromRot ();

	static void			SaveGraphFile (IUnknown *pUnkGraph, CString strPath);
};

#endif // !defined(AFX_DST_H__3222C041_9BF9_4662_9966_942A413ED4ED__INCLUDED_)
