/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: Dst.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// DST.cpp: implementation of the CHighRes class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Dst.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDSTHResult::CDSTHResult()
{

}

CDSTHResult::~CDSTHResult()
{

}



//////////////////////////////////////////////////////////////////////
CDSTHResult& CDSTHResult::operator= (HRESULT hr)
{
	m_hr = hr;

	if (FAILED(hr))
		throw CDSTFailQueryInterfaceException (hr);

	return *this;
}



//////////////////////////////////////////////////////////////////////
void CDSTHResult::CheckInterface (IUnknown* unk)
{
	if (unk == NULL)
	{
		m_hr = E_NOINTERFACE;
		throw CDSTFailQueryInterfaceException (m_hr);
	}
}



//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
CDSTSpy::CDSTSpy ()
{
	m_bInit = FALSE;
}

CDSTSpy::~CDSTSpy ()
{
	RemoveFromRot ();
}



/////////////////////////////////////////////////////////////////////////////
HRESULT CDSTSpy::AddToRot (IUnknown *pUnkGraph)
{
	if (m_bInit)
		RemoveFromRot ();

	CDSTHResult hr;

    CComPtr <IMoniker> pMoniker;
    CComPtr <IRunningObjectTable> pROT;
    
	hr = GetRunningObjectTable (0, &pROT);

    WCHAR wsz[256];
    wsprintfW(wsz, L"FilterGraph %08x pid %08x", (DWORD_PTR)pUnkGraph, GetCurrentProcessId());

    hr = CreateItemMoniker (L"!", wsz, &pMoniker);
	hr = pROT->Register (0, pUnkGraph, pMoniker, &m_register);
    
	m_bInit = TRUE;

    return S_OK;
}

/////////////////////////////////////////////////////////////////////////////
void CDSTSpy::RemoveFromRot ()
{
	if (!m_bInit)
		return;

	CDSTHResult hr;

    CComPtr <IRunningObjectTable> pROT;
    
	hr = GetRunningObjectTable (0, &pROT);
	pROT->Revoke (m_register);

	m_bInit = FALSE;
}



/////////////////////////////////////////////////////////////////////////////
void CDSTSpy::SaveGraphFile (IUnknown *pUnkGraph, CString strPath) 
{
	CComBSTR strWPath (strPath);
	WCHAR wszStreamName[] = L"ActiveMovieGraph"; 

    CDSTHResult hr;
    CComPtr <IStorage> pStorage;
    
	hr = StgCreateDocfile (strWPath, STGM_CREATE | STGM_TRANSACTED | STGM_READWRITE | STGM_SHARE_EXCLUSIVE, 0, &pStorage);
    
    CComPtr <IStream> pStream;
    hr = pStorage->CreateStream(wszStreamName, STGM_WRITE | STGM_CREATE | STGM_SHARE_EXCLUSIVE, 0, 0, &pStream);
    
    CComQIPtr <IPersistStream> pPersist;
    hr.CheckInterface (pPersist = pUnkGraph);

    hr = pPersist->Save (pStream, TRUE);
    hr = pStorage->Commit (STGC_DEFAULT);
}