/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: DropTarget.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// DropTargetList.cpp: implementation of the CDropTarget class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "DropTarget.h"
#include "MainFrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDropTarget::CDropTarget (CMainFrame* pMainWnd)
{
	m_pMainWnd = pMainWnd;
}

CDropTarget::~CDropTarget ()
{

}



//////////////////////////////////////////////////////////////////////
DROPEFFECT CDropTarget::OnDropEx (CWnd* pWnd, COleDataObject* pDataObject, DROPEFFECT dropDefault, DROPEFFECT dropList, CPoint point)
{
	if (pDataObject->IsDataAvailable (CF_HDROP))
	{
		HGLOBAL hGlobal = pDataObject->GetGlobalData (CF_HDROP);
		if (hGlobal)
		{
			BYTE* p = (BYTE*)::GlobalLock (hGlobal);
			
			LPDROPFILES pDropFiles;
			pDropFiles = (LPDROPFILES)p;
			p += pDropFiles->pFiles;

			CString strName;

			if (pDropFiles->fWide)
			{
				CString str ((LPCWSTR)p);
				strName = str;
			}
			else
			{
				CString str ((LPCTSTR)p);
				strName = str;
			}

			m_pMainWnd->OnDropFile (strName);

			::GlobalUnlock (hGlobal);
		}

		return DROPEFFECT_COPY;
	}

	return DROPEFFECT_NONE;
}



//////////////////////////////////////////////////////////////////////
DROPEFFECT CDropTarget::OnDragOver (CWnd* pWnd, COleDataObject* pDataObject, DWORD dwKeyState, CPoint point)
{
	if (pDataObject->IsDataAvailable (CF_HDROP))
		return DROPEFFECT_COPY;

	return DROPEFFECT_NONE;
}