/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: Device.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// Device.h: interface for the CDevice class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DEVICE_H__2047C125_3BCA_434C_BC76_6F8D8049BA5C__INCLUDED_)
#define AFX_DEVICE_H__2047C125_3BCA_434C_BC76_6F8D8049BA5C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CDevice  
{
protected:
	LONGLONG			m_tickCount; // Device ticks

public:
	CDevice();
	virtual ~CDevice();

	// Method for count device ticks 
	void				Reset ();
	void				NextTick ();

	// Virtual method called after reset command
	virtual void		OnReset () = 0;

	// Methods for Set/Get byte/word
	virtual void		GetByte (int addr, BYTE* pValue) = 0;
	virtual void		GetWord (int addr, WORD* pValue) = 0;
	virtual void		SetByte (int addr, BYTE value) = 0;
	virtual void		SetWord (int addr, WORD value) = 0;
};

#endif // !defined(AFX_DEVICE_H__2047C125_3BCA_434C_BC76_6F8D8049BA5C__INCLUDED_)
