/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: Defines.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




#if !defined DEFINES_H
#define DEFINES_H

#include "StdAfx.h"

//#define WM_DEBUG_UPDATE			WM_USER + 100
//#define WM_DUMP_UPDATE			WM_USER + 101
#define WM_MAINLOOP				(WM_USER + 101)
#define WM_RECEIVE_CMD_STRING	(WM_USER + 102)
//#define WM_BREAKPOINT			WM_USER + 102
#define WM_TAPE_FILE_LOAD		(WM_USER + 103)
#define WM_CPU_RUN				(WM_USER + 105)
#define WM_CPU_STOP				(WM_USER + 106)
#define WM_CPU_DEBUGBREAK		(WM_USER + 107)
#define WM_DEBUG_MODIFY			(WM_USER + 108)


#define SCREEN_WIDTH			512
#define SCREEN_HEIGHT			256

// Timers
#define TIMER_CPU					1

//#define REGISTERS_UPDATE_FREQUENCY	5
#define CPU_SETS_PER_SECOND			50
//#define CPU_TICKS_PER_SET			2600
#define CPU_TICKS_PER_SET			2646
#define SCRIPT_START_DELAY			1.0

// Registers
#define R0				(65536 * 10 + 0)
#define R1				(65536 * 10 + 2)
#define R2				(65536 * 10 + 4)
#define R3				(65536 * 10 + 6)
#define R4				(65536 * 10 + 8)
#define R5				(65536 * 10 + 10)
#define SP				(65536 * 10 + 12)
#define PC				(65536 * 10 + 14)
#define PSW				(65536 * 10 + 16) // Lie not in memory but in CPU

#define DEBUG_PC_BREAK	(65536 * 10 + 20)

// PSW bits
#define PSW_C			1
#define PSW_V			2
#define PSW_Z			4
#define PSW_N			8
#define	PSW_T			16
#define	PSW_P			0200

#define SRC				2
#define DST				0

// Interrups
#define NO_INTERRUPT	0000
#define INTERRUPT_4		0004
#define INTERRUPT_10	0010
#define INTERRUPT_14	0014
#define INTERRUPT_20	0020
#define INTERRUPT_24	0024
#define INTERRUPT_30	0030
#define INTERRUPT_34	0034
#define INTERRUPT_60	0060
#define INTERRUPT_100	0100
#define INTERRUPT_274	0274

// Commands

// No fields
#define PI_HALT			0000000
#define PI_WAIT			0000001
#define PI_RTI			0000002
#define PI_BPT			0000003
#define PI_IOT			0000004
#define PI_RESET		0000005
#define PI_RTT			0000006
#define PI_HALT10		0000010
#define PI_HALT11		0000011
#define PI_HALT12		0000012
#define PI_HALT13		0000013
#define PI_HALT14		0000014
#define PI_HALT15		0000015
#define PI_HALT16		0000016
#define PI_HALT17		0000017
#define PI_NOP			0000240
#define PI_CLC			0000241
#define PI_CLV			0000242
#define PI_CLVC			0000243
#define PI_CLZ			0000244
#define PI_CLZC			0000245
#define PI_CLZV			0000246
#define PI_CLZVC		0000247
#define PI_CLN			0000250
#define PI_CLNC			0000251
#define PI_CLNV			0000252
#define PI_CLNVC		0000253
#define PI_CLNZ			0000254
#define PI_CLNZC		0000255
#define PI_CLNZV		0000256
#define PI_CCC			0000257
#define PI_NOP260		0000260
#define PI_SEC			0000261
#define PI_SEV			0000262
#define PI_SEVC			0000263
#define PI_SEZ			0000264
#define PI_SEZC			0000265
#define PI_SEZV			0000266
#define PI_SEZVC		0000267
#define PI_SEN			0000270
#define PI_SENC			0000271
#define PI_SENV			0000272
#define PI_SENVC		0000273
#define PI_SENZ			0000274
#define PI_SENZC		0000275
#define PI_SENZV		0000276
#define PI_SCC			0000277

// One field
#define PI_RTS			0000200

// Two fields
#define PI_JMP			0000100
#define PI_SWAB			0000300
#define PI_CLR			0005000
#define PI_COM			0005100
#define PI_INC			0005200
#define PI_DEC			0005300
#define PI_NEG			0005400
#define PI_ADC			0005500
#define PI_SBC			0005600
#define PI_TST			0005700
#define PI_ROR			0006000
#define PI_ROL			0006100
#define PI_ASR			0006200
#define PI_ASL			0006300
#define PI_MARK			0006400
#define PI_SXT			0006700
#define PI_MTPS			0106400
#define PI_MFPS			0106700

// Branchs & interrupts
#define PI_BR			0000400
#define PI_BNE			0001000
#define PI_BEQ			0001400
#define PI_BGE			0002000
#define PI_BLT			0002400
#define PI_BGT			0003000
#define PI_BLE			0003400
#define PI_BPL			0100000
#define PI_BMI			0100400
#define PI_BHI			0101000
#define PI_BLOS			0101400
#define PI_BVC			0102000
#define PI_BVS			0102400
#define PI_BHIS			0103000
#define PI_BLO			0103400

#define PI_EMT			0104000
#define PI_TRAP			0104400

// Three fields
#define PI_JSR			0004000
#define PI_XOR			0074000
#define PI_SOB			0077000

// Four fields
#define PI_MOV			0010000
#define PI_CMP			0020000
#define PI_BIT			0030000
#define PI_BIC			0040000
#define PI_BIS			0050000

#define PI_ADD			0060000
#define PI_SUB			0160000

// Key codes
#define VK_BACK_SPACE	0000010
#define VK_ENTER		0000015
#define VK_PAGE_UP		0000041
#define VK_PAGE_DOWN	0000042

// BK Key codes
#define BKKEY_KT		0000003
#define BKKEY_L_ARROW	0000010
#define BKKEY_ENTER		0000012
#define BKKEY_SBR		0000014
#define BKKEY_RUS		0000016
#define BKKEY_LAT		0000017
#define BKKEY_VS		0000023
#define BKKEY_SDVIG		0000026
#define BKKEY_RAZDVIG	0000027
#define BKKEY_ZAB		0000030
#define BKKEY_R_ARROW	0000031
#define BKKEY_U_ARROW	0000032
#define BKKEY_D_ARROW	0000033
#define BKKEY_PROBEL	0000040

#endif