/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: Debugger.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// Debugger.h: interface for the CDebugger class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DEBUGGER_H__8D9F5791_7A54_422C_BB48_22DF0C831D06__INCLUDED_)
#define AFX_DEBUGGER_H__8D9F5791_7A54_422C_BB48_22DF0C831D06__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Device.h"
#include "DebugCtrl.h"
#include "Breakpoint.h"

//////////////////////////////////////////////////////////////////////
class CMotherBoard;

enum {MARK_COLUMN = 0, ADDR_COLUMN, INSTR_COLUMN, ARG_COLUMN, COM_COLUMN};
//////////////////////////////////////////////////////////////////////
class CDebugger : public CDevice
{
	static int			m_outLevel;

	WORD				m_address;
	int					m_nLines;
	CMotherBoard*		m_pChip;
	CDebugCtrl*			m_pCtrl;

	CBreakPointList		m_breakpointList;
	BOOL				m_bBreakCondition;

	// Virtual method called after reset command
	virtual void		OnReset ();

	// Methods for Set/Get byte/word
	virtual void		GetByte (int addr, BYTE* pValue);
	virtual void		GetWord (int addr, WORD* pValue);
	virtual void		SetByte (int addr, BYTE value);
	virtual void		SetWord (int addr, WORD value);

	WORD				GetLineAddress (int iNum);
	BOOL				ConvertSrcToString (WORD instr, WORD addr, CString& strSrc, WORD& code);
	BOOL				ConvertDstToString (WORD instr, WORD addr, CString& strDst, WORD& code);
	void				DrawMarker (WORD address, CDC* pDC, CRect& rc);

	// Breakpoint managment methods
	void				ApplyBreakpoints ();
	BOOL				IsBpeakpointExists (CBreakPoint& breakpoint);
	BOOL				IsBpeakpointAtAddress (int addr);

public:
	CDebugger();
	virtual ~CDebugger();

	static int			CalcInstructionLength (WORD instruction);
	static int			CalcArgLength (WORD instruction, int pos);
	static void			InitOutMode () {m_outLevel = 0;}
	static BOOL			IsInstructionOut (WORD instruction);
	static BOOL			IsInstructionOver (WORD instruction);

	void				AttachChip (CMotherBoard* pChip) {m_pChip = pChip; ApplyBreakpoints ();}
	void				AttachWnd (CDebugCtrl* pCtrl) {m_pCtrl = pCtrl;}
	void				SetLinesNum (int nNum) {m_nLines = nNum;}
	void				SetCurrentAddress (WORD address) {m_address = address; m_pCtrl->Invalidate (FALSE);}
	WORD				GetCurrentAddress () {return m_address;}

	int					DebugInstruction (WORD addr, CString& strInstr, CString& strArg, WORD* codes);
	void				DrawDeguggerLine (int nNum, CDC* pDC, CRect& rcLine, CRect* pRcSubs);

	void				StepForward ();
	void				StepBackward ();

	WORD				GetCursorAddress ();
	WORD				GetBottomAddress ();

	WORD				GetPSW ();
	WORD				GetWordValue (int addr);
	void				GetMemoryDump (WORD* pBuff, WORD addr, int length);

	// Breakpoint managment methods
	BOOL				SetSimpleBreakpoint (WORD addr);
	BOOL				SetSimpleBreakpoint ();
	BOOL				RemoveBreakpoint (WORD addr);
	BOOL				RemoveBreakpoint ();
};

#endif // !defined(AFX_DEBUGGER_H__8D9F5791_7A54_422C_BB48_22DF0C831D06__INCLUDED_)
