/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: DebugCtrl.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// DebugCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "bk.h"
#include "DebugCtrl.h"
#include "Debugger.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDebugCtrl

CDebugCtrl::CDebugCtrl()
{
	m_pDebugger = NULL;
	m_selection = -1;
}

CDebugCtrl::~CDebugCtrl()
{
}


BEGIN_MESSAGE_MAP(CDebugCtrl, CListCtrl)
	//{{AFX_MSG_MAP(CDebugCtrl)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_NOTIFY_REFLECT(LVN_ITEMCHANGED, OnItemchanged)
	ON_NOTIFY_REFLECT(LVN_KEYDOWN, OnKeydown)
	ON_NOTIFY_REFLECT(NM_CUSTOMDRAW, OnCustomDraw)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDebugCtrl message handlers

int CDebugCtrl::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CListCtrl::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	ModifyStyle (0, LVS_REPORT|LVS_OWNERDATA|LVS_SHOWSELALWAYS|LVS_NOSORTHEADER);
	SetExtendedStyle (LVS_EX_FULLROWSELECT);

	CRect rcDebug;
	GetClientRect (&rcDebug);

	// Create Header
	CString strHeader;

	strHeader.LoadString (IDS_DEBUG_MARK);
	InsertColumn (0, strHeader, LVCFMT_LEFT, 20);
	strHeader.LoadString (IDS_DEBUG_ADDRESS);
	InsertColumn (1, strHeader, LVCFMT_LEFT, 70);
	strHeader.LoadString (IDS_DEBUG_COMMAND);
	InsertColumn (2, strHeader, LVCFMT_LEFT, 70);
	strHeader.LoadString (IDS_DEBUG_ARGUMENTS);
	InsertColumn (3, strHeader, LVCFMT_LEFT, 140);
	strHeader.LoadString (IDS_DEBUG_COMMENTS);
	InsertColumn (4, strHeader, LVCFMT_LEFT, 200);
	
	return 0;
}



/////////////////////////////////////////////////////////////////////////////
void CDebugCtrl::OnSize(UINT nType, int cx, int cy) 
{
	CListCtrl::OnSize(nType, cx, cy);
	
	static bLock = FALSE;

	if (!bLock)
	{
		// Lock for recurce call preserve
		bLock = TRUE;

		int nCount = GetCountPerPage ();

		// Delete All Items
		DeleteAllItems ();

		if (nCount != -1)
		{
			// Insert new items 
			for (int i = 0; i < nCount; i++)
			{
				InsertItem (i, LPSTR_TEXTCALLBACK);

				if (i == m_selection)
					SetItemState (m_selection, LVIS_SELECTED|LVIS_FOCUSED, LVIS_SELECTED|LVIS_FOCUSED);
			}
		}

		if (m_pDebugger)
			m_pDebugger->SetLinesNum (nCount);

		// Unlock
		bLock = FALSE;
	}
}



/////////////////////////////////////////////////////////////////////////////
void CDebugCtrl::OnItemchanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	
	// Change selection marker
	if (pNMListView->iItem != -1 && pNMListView->uNewState & LVIS_SELECTED)
		m_selection = pNMListView->iItem;
	
	*pResult = 0;
}



/////////////////////////////////////////////////////////////////////////////
void CDebugCtrl::OnKeydown(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_KEYDOWN* pLVKeyDow = (LV_KEYDOWN*)pNMHDR;

	int nLastItem = GetItemCount () - 1;

	if (GetSelectionMark () == 0 && pLVKeyDow->wVKey == VK_UP)
	{
		if (m_pDebugger)
			m_pDebugger->StepBackward ();

		RedrawItems (0, nLastItem);
	}

	if (GetSelectionMark () == nLastItem && pLVKeyDow->wVKey == VK_DOWN)
	{
		if (m_pDebugger)
			m_pDebugger->StepForward ();

		RedrawItems (0, nLastItem);
	}	
	
	*pResult = 0;
}



/////////////////////////////////////////////////////////////////////////////
void CDebugCtrl::OnCustomDraw(NMHDR* pNMHDR, LRESULT* pResult)
{
	NMCUSTOMDRAW* pCustomDraw = (NMCUSTOMDRAW*)pNMHDR;

	*pResult = 0;

	switch (pCustomDraw->dwDrawStage)
	{
	case CDDS_PREPAINT:
		*pResult = CDRF_NOTIFYITEMDRAW;
		break;
	
	case CDDS_ITEMPREPAINT:
		*pResult = CDRF_NOTIFYPOSTPAINT;
		break;

	case CDDS_ITEMPOSTPAINT:
		if (m_pDebugger)
		{
			// Get item index
			int nIndex = pCustomDraw->dwItemSpec;
			CRect rcItem;

			// Get item bounds rectangles
			GetItemRect (nIndex, &rcItem, LVIR_BOUNDS);

			// Get subitems rectangles
			CRect rcSubs[5];
			GetSubItemRect (nIndex, MARK_COLUMN, LVIR_LABEL, rcSubs[MARK_COLUMN]);
			GetSubItemRect (nIndex, ADDR_COLUMN, LVIR_BOUNDS, rcSubs[ADDR_COLUMN]);
			GetSubItemRect (nIndex, INSTR_COLUMN, LVIR_BOUNDS, rcSubs[INSTR_COLUMN]);
			GetSubItemRect (nIndex, ARG_COLUMN, LVIR_BOUNDS, rcSubs[ARG_COLUMN]);
			GetSubItemRect (nIndex, COM_COLUMN, LVIR_BOUNDS, rcSubs[COM_COLUMN]);

			m_pDebugger->DrawDeguggerLine (nIndex, CDC::FromHandle (pCustomDraw->hdc), rcItem, rcSubs);
		}
		break;
	}
}
